package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateAdvancedSetting invokes the elasticsearch.UpdateAdvancedSetting API synchronously
func (client *Client) UpdateAdvancedSetting(request *UpdateAdvancedSettingRequest) (response *UpdateAdvancedSettingResponse, err error) {
	response = CreateUpdateAdvancedSettingResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateAdvancedSettingWithChan invokes the elasticsearch.UpdateAdvancedSetting API asynchronously
func (client *Client) UpdateAdvancedSettingWithChan(request *UpdateAdvancedSettingRequest) (<-chan *UpdateAdvancedSettingResponse, <-chan error) {
	responseChan := make(chan *UpdateAdvancedSettingResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateAdvancedSetting(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateAdvancedSettingWithCallback invokes the elasticsearch.UpdateAdvancedSetting API asynchronously
func (client *Client) UpdateAdvancedSettingWithCallback(request *UpdateAdvancedSettingRequest, callback func(response *UpdateAdvancedSettingResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateAdvancedSettingResponse
		var err error
		defer close(result)
		response, err = client.UpdateAdvancedSetting(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateAdvancedSettingRequest is the request struct for api UpdateAdvancedSetting
type UpdateAdvancedSettingRequest struct {
	*requests.RoaRequest
	InstanceId  string `position:"Path" name:"InstanceId"`
	ClientToken string `position:"Query" name:"clientToken"`
	Body        string `position:"Body" name:"body"`
}

// UpdateAdvancedSettingResponse is the response struct for api UpdateAdvancedSetting
type UpdateAdvancedSettingResponse struct {
	*responses.BaseResponse
	Result    bool   `json:"Result" xml:"Result"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateAdvancedSettingRequest creates a request to invoke UpdateAdvancedSetting API
func CreateUpdateAdvancedSettingRequest() (request *UpdateAdvancedSettingRequest) {
	request = &UpdateAdvancedSettingRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "UpdateAdvancedSetting", "/openapi/instances/[InstanceId]/actions/update-advanced-setting", "elasticsearch", "openAPI")
	request.Method = requests.POST
	return
}

// CreateUpdateAdvancedSettingResponse creates a response to parse from UpdateAdvancedSetting response
func CreateUpdateAdvancedSettingResponse() (response *UpdateAdvancedSettingResponse) {
	response = &UpdateAdvancedSettingResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
