package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListDataTasks invokes the elasticsearch.ListDataTasks API synchronously
func (client *Client) ListDataTasks(request *ListDataTasksRequest) (response *ListDataTasksResponse, err error) {
	response = CreateListDataTasksResponse()
	err = client.DoAction(request, response)
	return
}

// ListDataTasksWithChan invokes the elasticsearch.ListDataTasks API asynchronously
func (client *Client) ListDataTasksWithChan(request *ListDataTasksRequest) (<-chan *ListDataTasksResponse, <-chan error) {
	responseChan := make(chan *ListDataTasksResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListDataTasks(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListDataTasksWithCallback invokes the elasticsearch.ListDataTasks API asynchronously
func (client *Client) ListDataTasksWithCallback(request *ListDataTasksRequest, callback func(response *ListDataTasksResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListDataTasksResponse
		var err error
		defer close(result)
		response, err = client.ListDataTasks(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListDataTasksRequest is the request struct for api ListDataTasks
type ListDataTasksRequest struct {
	*requests.RoaRequest
	InstanceId string `position:"Path" name:"InstanceId"`
}

// ListDataTasksResponse is the response struct for api ListDataTasks
type ListDataTasksResponse struct {
	*responses.BaseResponse
	RequestId string       `json:"RequestId" xml:"RequestId"`
	Result    []ResultItem `json:"Result" xml:"Result"`
}

// CreateListDataTasksRequest creates a request to invoke ListDataTasks API
func CreateListDataTasksRequest() (request *ListDataTasksRequest) {
	request = &ListDataTasksRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "ListDataTasks", "/openapi/instances/[InstanceId]/data-task", "elasticsearch", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListDataTasksResponse creates a response to parse from ListDataTasks response
func CreateListDataTasksResponse() (response *ListDataTasksResponse) {
	response = &ListDataTasksResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
