package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListApm invokes the elasticsearch.ListApm API synchronously
func (client *Client) ListApm(request *ListApmRequest) (response *ListApmResponse, err error) {
	response = CreateListApmResponse()
	err = client.DoAction(request, response)
	return
}

// ListApmWithChan invokes the elasticsearch.ListApm API asynchronously
func (client *Client) ListApmWithChan(request *ListApmRequest) (<-chan *ListApmResponse, <-chan error) {
	responseChan := make(chan *ListApmResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListApm(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListApmWithCallback invokes the elasticsearch.ListApm API asynchronously
func (client *Client) ListApmWithCallback(request *ListApmRequest, callback func(response *ListApmResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListApmResponse
		var err error
		defer close(result)
		response, err = client.ListApm(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListApmRequest is the request struct for api ListApm
type ListApmRequest struct {
	*requests.RoaRequest
	Output      string           `position:"Query" name:"output"`
	InstanceId  string           `position:"Query" name:"instanceId"`
	Size        requests.Integer `position:"Query" name:"size"`
	Description string           `position:"Query" name:"description"`
	Page        requests.Integer `position:"Query" name:"page"`
}

// ListApmResponse is the response struct for api ListApm
type ListApmResponse struct {
	*responses.BaseResponse
	RequestId string   `json:"RequestId" xml:"RequestId"`
	Headers   Headers  `json:"Headers" xml:"Headers"`
	Result    []Object `json:"Result" xml:"Result"`
}

// CreateListApmRequest creates a request to invoke ListApm API
func CreateListApmRequest() (request *ListApmRequest) {
	request = &ListApmRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "ListApm", "/openapi/apm", "elasticsearch", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListApmResponse creates a response to parse from ListApm response
func CreateListApmResponse() (response *ListApmResponse) {
	response = &ListApmResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
