package elasticsearch

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetRegionalInstanceConfig invokes the elasticsearch.GetRegionalInstanceConfig API synchronously
func (client *Client) GetRegionalInstanceConfig(request *GetRegionalInstanceConfigRequest) (response *GetRegionalInstanceConfigResponse, err error) {
	response = CreateGetRegionalInstanceConfigResponse()
	err = client.DoAction(request, response)
	return
}

// GetRegionalInstanceConfigWithChan invokes the elasticsearch.GetRegionalInstanceConfig API asynchronously
func (client *Client) GetRegionalInstanceConfigWithChan(request *GetRegionalInstanceConfigRequest) (<-chan *GetRegionalInstanceConfigResponse, <-chan error) {
	responseChan := make(chan *GetRegionalInstanceConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetRegionalInstanceConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetRegionalInstanceConfigWithCallback invokes the elasticsearch.GetRegionalInstanceConfig API asynchronously
func (client *Client) GetRegionalInstanceConfigWithCallback(request *GetRegionalInstanceConfigRequest, callback func(response *GetRegionalInstanceConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetRegionalInstanceConfigResponse
		var err error
		defer close(result)
		response, err = client.GetRegionalInstanceConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetRegionalInstanceConfigRequest is the request struct for api GetRegionalInstanceConfig
type GetRegionalInstanceConfigRequest struct {
	*requests.RoaRequest
}

// GetRegionalInstanceConfigResponse is the response struct for api GetRegionalInstanceConfig
type GetRegionalInstanceConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateGetRegionalInstanceConfigRequest creates a request to invoke GetRegionalInstanceConfig API
func CreateGetRegionalInstanceConfigRequest() (request *GetRegionalInstanceConfigRequest) {
	request = &GetRegionalInstanceConfigRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("elasticsearch", "2017-06-13", "GetRegionalInstanceConfig", "/openapi/regions/instance-config", "elasticsearch", "openAPI")
	request.Method = requests.GET
	return
}

// CreateGetRegionalInstanceConfigResponse creates a response to parse from GetRegionalInstanceConfig response
func CreateGetRegionalInstanceConfigResponse() (response *GetRegionalInstanceConfigResponse) {
	response = &GetRegionalInstanceConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
