package eflo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListInstancesByNcd invokes the eflo.ListInstancesByNcd API synchronously
func (client *Client) ListInstancesByNcd(request *ListInstancesByNcdRequest) (response *ListInstancesByNcdResponse, err error) {
	response = CreateListInstancesByNcdResponse()
	err = client.DoAction(request, response)
	return
}

// ListInstancesByNcdWithChan invokes the eflo.ListInstancesByNcd API asynchronously
func (client *Client) ListInstancesByNcdWithChan(request *ListInstancesByNcdRequest) (<-chan *ListInstancesByNcdResponse, <-chan error) {
	responseChan := make(chan *ListInstancesByNcdResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListInstancesByNcd(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListInstancesByNcdWithCallback invokes the eflo.ListInstancesByNcd API asynchronously
func (client *Client) ListInstancesByNcdWithCallback(request *ListInstancesByNcdRequest, callback func(response *ListInstancesByNcdResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListInstancesByNcdResponse
		var err error
		defer close(result)
		response, err = client.ListInstancesByNcd(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListInstancesByNcdRequest is the request struct for api ListInstancesByNcd
type ListInstancesByNcdRequest struct {
	*requests.RpcRequest
	MaxNcd       requests.Integer `position:"Body" name:"MaxNcd"`
	InstanceId   string           `position:"Body" name:"InstanceId"`
	InstanceType string           `position:"Body" name:"InstanceType"`
}

// ListInstancesByNcdResponse is the response struct for api ListInstancesByNcd
type ListInstancesByNcdResponse struct {
	*responses.BaseResponse
	Code      int     `json:"Code" xml:"Code"`
	Message   string  `json:"Message" xml:"Message"`
	RequestId string  `json:"RequestId" xml:"RequestId"`
	Content   Content `json:"Content" xml:"Content"`
}

// CreateListInstancesByNcdRequest creates a request to invoke ListInstancesByNcd API
func CreateListInstancesByNcdRequest() (request *ListInstancesByNcdRequest) {
	request = &ListInstancesByNcdRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("eflo", "2022-05-30", "ListInstancesByNcd", "eflo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListInstancesByNcdResponse creates a response to parse from ListInstancesByNcd response
func CreateListInstancesByNcdResponse() (response *ListInstancesByNcdResponse) {
	response = &ListInstancesByNcdResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
