package edas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListK8sNamespaces invokes the edas.ListK8sNamespaces API synchronously
func (client *Client) ListK8sNamespaces(request *ListK8sNamespacesRequest) (response *ListK8sNamespacesResponse, err error) {
	response = CreateListK8sNamespacesResponse()
	err = client.DoAction(request, response)
	return
}

// ListK8sNamespacesWithChan invokes the edas.ListK8sNamespaces API asynchronously
func (client *Client) ListK8sNamespacesWithChan(request *ListK8sNamespacesRequest) (<-chan *ListK8sNamespacesResponse, <-chan error) {
	responseChan := make(chan *ListK8sNamespacesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListK8sNamespaces(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListK8sNamespacesWithCallback invokes the edas.ListK8sNamespaces API asynchronously
func (client *Client) ListK8sNamespacesWithCallback(request *ListK8sNamespacesRequest, callback func(response *ListK8sNamespacesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListK8sNamespacesResponse
		var err error
		defer close(result)
		response, err = client.ListK8sNamespaces(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListK8sNamespacesRequest is the request struct for api ListK8sNamespaces
type ListK8sNamespacesRequest struct {
	*requests.RoaRequest
	ClusterId string `position:"Query" name:"ClusterId"`
}

// ListK8sNamespacesResponse is the response struct for api ListK8sNamespaces
type ListK8sNamespacesResponse struct {
	*responses.BaseResponse
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Code      int        `json:"Code" xml:"Code"`
	Message   string     `json:"Message" xml:"Message"`
	Data      []DataItem `json:"Data" xml:"Data"`
}

// CreateListK8sNamespacesRequest creates a request to invoke ListK8sNamespaces API
func CreateListK8sNamespacesRequest() (request *ListK8sNamespacesRequest) {
	request = &ListK8sNamespacesRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("Edas", "2017-08-01", "ListK8sNamespaces", "/pop/v5/k8s/acs/k8s_namespace", "Edas", "openAPI")
	request.Method = requests.GET
	return
}

// CreateListK8sNamespacesResponse creates a response to parse from ListK8sNamespaces response
func CreateListK8sNamespacesResponse() (response *ListK8sNamespacesResponse) {
	response = &ListK8sNamespacesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
