package ecs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyDiagnosticMetricSet invokes the ecs.ModifyDiagnosticMetricSet API synchronously
func (client *Client) ModifyDiagnosticMetricSet(request *ModifyDiagnosticMetricSetRequest) (response *ModifyDiagnosticMetricSetResponse, err error) {
	response = CreateModifyDiagnosticMetricSetResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyDiagnosticMetricSetWithChan invokes the ecs.ModifyDiagnosticMetricSet API asynchronously
func (client *Client) ModifyDiagnosticMetricSetWithChan(request *ModifyDiagnosticMetricSetRequest) (<-chan *ModifyDiagnosticMetricSetResponse, <-chan error) {
	responseChan := make(chan *ModifyDiagnosticMetricSetResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyDiagnosticMetricSet(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyDiagnosticMetricSetWithCallback invokes the ecs.ModifyDiagnosticMetricSet API asynchronously
func (client *Client) ModifyDiagnosticMetricSetWithCallback(request *ModifyDiagnosticMetricSetRequest, callback func(response *ModifyDiagnosticMetricSetResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyDiagnosticMetricSetResponse
		var err error
		defer close(result)
		response, err = client.ModifyDiagnosticMetricSet(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyDiagnosticMetricSetRequest is the request struct for api ModifyDiagnosticMetricSet
type ModifyDiagnosticMetricSetRequest struct {
	*requests.RpcRequest
	MetricIds     *[]string `position:"Query" name:"MetricIds"  type:"Repeated"`
	MetricSetId   string    `position:"Query" name:"MetricSetId"`
	Description   string    `position:"Query" name:"Description"`
	MetricSetName string    `position:"Query" name:"MetricSetName"`
	ResourceType  string    `position:"Query" name:"ResourceType"`
}

// ModifyDiagnosticMetricSetResponse is the response struct for api ModifyDiagnosticMetricSet
type ModifyDiagnosticMetricSetResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyDiagnosticMetricSetRequest creates a request to invoke ModifyDiagnosticMetricSet API
func CreateModifyDiagnosticMetricSetRequest() (request *ModifyDiagnosticMetricSetRequest) {
	request = &ModifyDiagnosticMetricSetRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ecs", "2014-05-26", "ModifyDiagnosticMetricSet", "ecs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyDiagnosticMetricSetResponse creates a response to parse from ModifyDiagnosticMetricSet response
func CreateModifyDiagnosticMetricSetResponse() (response *ModifyDiagnosticMetricSetResponse) {
	response = &ModifyDiagnosticMetricSetResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
