package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyCustomizedListHeaders invokes the ecd.ModifyCustomizedListHeaders API synchronously
func (client *Client) ModifyCustomizedListHeaders(request *ModifyCustomizedListHeadersRequest) (response *ModifyCustomizedListHeadersResponse, err error) {
	response = CreateModifyCustomizedListHeadersResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyCustomizedListHeadersWithChan invokes the ecd.ModifyCustomizedListHeaders API asynchronously
func (client *Client) ModifyCustomizedListHeadersWithChan(request *ModifyCustomizedListHeadersRequest) (<-chan *ModifyCustomizedListHeadersResponse, <-chan error) {
	responseChan := make(chan *ModifyCustomizedListHeadersResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyCustomizedListHeaders(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyCustomizedListHeadersWithCallback invokes the ecd.ModifyCustomizedListHeaders API asynchronously
func (client *Client) ModifyCustomizedListHeadersWithCallback(request *ModifyCustomizedListHeadersRequest, callback func(response *ModifyCustomizedListHeadersResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyCustomizedListHeadersResponse
		var err error
		defer close(result)
		response, err = client.ModifyCustomizedListHeaders(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyCustomizedListHeadersRequest is the request struct for api ModifyCustomizedListHeaders
type ModifyCustomizedListHeadersRequest struct {
	*requests.RpcRequest
	Headers  *[]ModifyCustomizedListHeadersHeaders `position:"Query" name:"Headers"  type:"Repeated"`
	ListType string                                `position:"Query" name:"ListType"`
}

// ModifyCustomizedListHeadersHeaders is a repeated param struct in ModifyCustomizedListHeadersRequest
type ModifyCustomizedListHeadersHeaders struct {
	DisplayType string `name:"DisplayType"`
	HeaderKey   string `name:"HeaderKey"`
}

// ModifyCustomizedListHeadersResponse is the response struct for api ModifyCustomizedListHeaders
type ModifyCustomizedListHeadersResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyCustomizedListHeadersRequest creates a request to invoke ModifyCustomizedListHeaders API
func CreateModifyCustomizedListHeadersRequest() (request *ModifyCustomizedListHeadersRequest) {
	request = &ModifyCustomizedListHeadersRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "ModifyCustomizedListHeaders", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyCustomizedListHeadersResponse creates a response to parse from ModifyCustomizedListHeaders response
func CreateModifyCustomizedListHeadersResponse() (response *ModifyCustomizedListHeadersResponse) {
	response = &ModifyCustomizedListHeadersResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
