package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetSpMetadata invokes the ecd.GetSpMetadata API synchronously
func (client *Client) GetSpMetadata(request *GetSpMetadataRequest) (response *GetSpMetadataResponse, err error) {
	response = CreateGetSpMetadataResponse()
	err = client.DoAction(request, response)
	return
}

// GetSpMetadataWithChan invokes the ecd.GetSpMetadata API asynchronously
func (client *Client) GetSpMetadataWithChan(request *GetSpMetadataRequest) (<-chan *GetSpMetadataResponse, <-chan error) {
	responseChan := make(chan *GetSpMetadataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetSpMetadata(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetSpMetadataWithCallback invokes the ecd.GetSpMetadata API asynchronously
func (client *Client) GetSpMetadataWithCallback(request *GetSpMetadataRequest, callback func(response *GetSpMetadataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetSpMetadataResponse
		var err error
		defer close(result)
		response, err = client.GetSpMetadata(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetSpMetadataRequest is the request struct for api GetSpMetadata
type GetSpMetadataRequest struct {
	*requests.RpcRequest
	OfficeSiteId string `position:"Query" name:"OfficeSiteId"`
	DirectoryId  string `position:"Query" name:"DirectoryId"`
}

// GetSpMetadataResponse is the response struct for api GetSpMetadata
type GetSpMetadataResponse struct {
	*responses.BaseResponse
	SpMetadata string `json:"SpMetadata" xml:"SpMetadata"`
	RequestId  string `json:"RequestId" xml:"RequestId"`
}

// CreateGetSpMetadataRequest creates a request to invoke GetSpMetadata API
func CreateGetSpMetadataRequest() (request *GetSpMetadataRequest) {
	request = &GetSpMetadataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "GetSpMetadata", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetSpMetadataResponse creates a response to parse from GetSpMetadata response
func CreateGetSpMetadataResponse() (response *GetSpMetadataResponse) {
	response = &GetSpMetadataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
