package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ExportClientEvents invokes the ecd.ExportClientEvents API synchronously
func (client *Client) ExportClientEvents(request *ExportClientEventsRequest) (response *ExportClientEventsResponse, err error) {
	response = CreateExportClientEventsResponse()
	err = client.DoAction(request, response)
	return
}

// ExportClientEventsWithChan invokes the ecd.ExportClientEvents API asynchronously
func (client *Client) ExportClientEventsWithChan(request *ExportClientEventsRequest) (<-chan *ExportClientEventsResponse, <-chan error) {
	responseChan := make(chan *ExportClientEventsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ExportClientEvents(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ExportClientEventsWithCallback invokes the ecd.ExportClientEvents API asynchronously
func (client *Client) ExportClientEventsWithCallback(request *ExportClientEventsRequest, callback func(response *ExportClientEventsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ExportClientEventsResponse
		var err error
		defer close(result)
		response, err = client.ExportClientEvents(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ExportClientEventsRequest is the request struct for api ExportClientEvents
type ExportClientEventsRequest struct {
	*requests.RpcRequest
	OfficeSiteId   string           `position:"Query" name:"OfficeSiteId"`
	EventTypes     *[]string        `position:"Query" name:"EventTypes"  type:"Repeated"`
	StartTime      string           `position:"Query" name:"StartTime"`
	EndUserId      string           `position:"Query" name:"EndUserId"`
	DesktopId      string           `position:"Query" name:"DesktopId"`
	DesktopName    string           `position:"Query" name:"DesktopName"`
	EndTime        string           `position:"Query" name:"EndTime"`
	OfficeSiteName string           `position:"Query" name:"OfficeSiteName"`
	MaxResults     requests.Integer `position:"Query" name:"MaxResults"`
	EventType      string           `position:"Query" name:"EventType"`
	LangType       string           `position:"Query" name:"LangType"`
}

// ExportClientEventsResponse is the response struct for api ExportClientEvents
type ExportClientEventsResponse struct {
	*responses.BaseResponse
	Url       string `json:"Url" xml:"Url"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateExportClientEventsRequest creates a request to invoke ExportClientEvents API
func CreateExportClientEventsRequest() (request *ExportClientEventsRequest) {
	request = &ExportClientEventsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "ExportClientEvents", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateExportClientEventsResponse creates a response to parse from ExportClientEvents response
func CreateExportClientEventsResponse() (response *ExportClientEventsResponse) {
	response = &ExportClientEventsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
