package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DetachEndUser invokes the ecd.DetachEndUser API synchronously
func (client *Client) DetachEndUser(request *DetachEndUserRequest) (response *DetachEndUserResponse, err error) {
	response = CreateDetachEndUserResponse()
	err = client.DoAction(request, response)
	return
}

// DetachEndUserWithChan invokes the ecd.DetachEndUser API asynchronously
func (client *Client) DetachEndUserWithChan(request *DetachEndUserRequest) (<-chan *DetachEndUserResponse, <-chan error) {
	responseChan := make(chan *DetachEndUserResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DetachEndUser(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DetachEndUserWithCallback invokes the ecd.DetachEndUser API asynchronously
func (client *Client) DetachEndUserWithCallback(request *DetachEndUserRequest, callback func(response *DetachEndUserResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DetachEndUserResponse
		var err error
		defer close(result)
		response, err = client.DetachEndUser(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DetachEndUserRequest is the request struct for api DetachEndUser
type DetachEndUserRequest struct {
	*requests.RpcRequest
	ClientType  string `position:"Query" name:"ClientType"`
	DeviceId    string `position:"Query" name:"DeviceId"`
	AdDomain    string `position:"Query" name:"AdDomain"`
	EndUserId   string `position:"Query" name:"EndUserId"`
	DirectoryId string `position:"Query" name:"DirectoryId"`
	Region      string `position:"Query" name:"Region"`
}

// DetachEndUserResponse is the response struct for api DetachEndUser
type DetachEndUserResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDetachEndUserRequest creates a request to invoke DetachEndUser API
func CreateDetachEndUserRequest() (request *DetachEndUserRequest) {
	request = &DetachEndUserRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "DetachEndUser", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDetachEndUserResponse creates a response to parse from DetachEndUser response
func CreateDetachEndUserResponse() (response *DetachEndUserResponse) {
	response = &DetachEndUserResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
