package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribePriceForRenewDesktopOversoldGroup invokes the ecd.DescribePriceForRenewDesktopOversoldGroup API synchronously
func (client *Client) DescribePriceForRenewDesktopOversoldGroup(request *DescribePriceForRenewDesktopOversoldGroupRequest) (response *DescribePriceForRenewDesktopOversoldGroupResponse, err error) {
	response = CreateDescribePriceForRenewDesktopOversoldGroupResponse()
	err = client.DoAction(request, response)
	return
}

// DescribePriceForRenewDesktopOversoldGroupWithChan invokes the ecd.DescribePriceForRenewDesktopOversoldGroup API asynchronously
func (client *Client) DescribePriceForRenewDesktopOversoldGroupWithChan(request *DescribePriceForRenewDesktopOversoldGroupRequest) (<-chan *DescribePriceForRenewDesktopOversoldGroupResponse, <-chan error) {
	responseChan := make(chan *DescribePriceForRenewDesktopOversoldGroupResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribePriceForRenewDesktopOversoldGroup(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribePriceForRenewDesktopOversoldGroupWithCallback invokes the ecd.DescribePriceForRenewDesktopOversoldGroup API asynchronously
func (client *Client) DescribePriceForRenewDesktopOversoldGroupWithCallback(request *DescribePriceForRenewDesktopOversoldGroupRequest, callback func(response *DescribePriceForRenewDesktopOversoldGroupResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribePriceForRenewDesktopOversoldGroupResponse
		var err error
		defer close(result)
		response, err = client.DescribePriceForRenewDesktopOversoldGroup(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribePriceForRenewDesktopOversoldGroupRequest is the request struct for api DescribePriceForRenewDesktopOversoldGroup
type DescribePriceForRenewDesktopOversoldGroupRequest struct {
	*requests.RpcRequest
	Period          requests.Integer `position:"Query" name:"Period"`
	OversoldGroupId string           `position:"Query" name:"OversoldGroupId"`
	PeriodUnit      string           `position:"Query" name:"PeriodUnit"`
}

// DescribePriceForRenewDesktopOversoldGroupResponse is the response struct for api DescribePriceForRenewDesktopOversoldGroup
type DescribePriceForRenewDesktopOversoldGroupResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDescribePriceForRenewDesktopOversoldGroupRequest creates a request to invoke DescribePriceForRenewDesktopOversoldGroup API
func CreateDescribePriceForRenewDesktopOversoldGroupRequest() (request *DescribePriceForRenewDesktopOversoldGroupRequest) {
	request = &DescribePriceForRenewDesktopOversoldGroupRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "DescribePriceForRenewDesktopOversoldGroup", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribePriceForRenewDesktopOversoldGroupResponse creates a response to parse from DescribePriceForRenewDesktopOversoldGroup response
func CreateDescribePriceForRenewDesktopOversoldGroupResponse() (response *DescribePriceForRenewDesktopOversoldGroupResponse) {
	response = &DescribePriceForRenewDesktopOversoldGroupResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
