package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribePriceForModifyDesktopOversoldGroupSale invokes the ecd.DescribePriceForModifyDesktopOversoldGroupSale API synchronously
func (client *Client) DescribePriceForModifyDesktopOversoldGroupSale(request *DescribePriceForModifyDesktopOversoldGroupSaleRequest) (response *DescribePriceForModifyDesktopOversoldGroupSaleResponse, err error) {
	response = CreateDescribePriceForModifyDesktopOversoldGroupSaleResponse()
	err = client.DoAction(request, response)
	return
}

// DescribePriceForModifyDesktopOversoldGroupSaleWithChan invokes the ecd.DescribePriceForModifyDesktopOversoldGroupSale API asynchronously
func (client *Client) DescribePriceForModifyDesktopOversoldGroupSaleWithChan(request *DescribePriceForModifyDesktopOversoldGroupSaleRequest) (<-chan *DescribePriceForModifyDesktopOversoldGroupSaleResponse, <-chan error) {
	responseChan := make(chan *DescribePriceForModifyDesktopOversoldGroupSaleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribePriceForModifyDesktopOversoldGroupSale(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribePriceForModifyDesktopOversoldGroupSaleWithCallback invokes the ecd.DescribePriceForModifyDesktopOversoldGroupSale API asynchronously
func (client *Client) DescribePriceForModifyDesktopOversoldGroupSaleWithCallback(request *DescribePriceForModifyDesktopOversoldGroupSaleRequest, callback func(response *DescribePriceForModifyDesktopOversoldGroupSaleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribePriceForModifyDesktopOversoldGroupSaleResponse
		var err error
		defer close(result)
		response, err = client.DescribePriceForModifyDesktopOversoldGroupSale(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribePriceForModifyDesktopOversoldGroupSaleRequest is the request struct for api DescribePriceForModifyDesktopOversoldGroupSale
type DescribePriceForModifyDesktopOversoldGroupSaleRequest struct {
	*requests.RpcRequest
	OversoldGroupId   string           `position:"Query" name:"OversoldGroupId"`
	OversoldUserCount requests.Integer `position:"Query" name:"OversoldUserCount"`
	ConcurrenceCount  requests.Integer `position:"Query" name:"ConcurrenceCount"`
}

// DescribePriceForModifyDesktopOversoldGroupSaleResponse is the response struct for api DescribePriceForModifyDesktopOversoldGroupSale
type DescribePriceForModifyDesktopOversoldGroupSaleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDescribePriceForModifyDesktopOversoldGroupSaleRequest creates a request to invoke DescribePriceForModifyDesktopOversoldGroupSale API
func CreateDescribePriceForModifyDesktopOversoldGroupSaleRequest() (request *DescribePriceForModifyDesktopOversoldGroupSaleRequest) {
	request = &DescribePriceForModifyDesktopOversoldGroupSaleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "DescribePriceForModifyDesktopOversoldGroupSale", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribePriceForModifyDesktopOversoldGroupSaleResponse creates a response to parse from DescribePriceForModifyDesktopOversoldGroupSale response
func CreateDescribePriceForModifyDesktopOversoldGroupSaleResponse() (response *DescribePriceForModifyDesktopOversoldGroupSaleResponse) {
	response = &DescribePriceForModifyDesktopOversoldGroupSaleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
