package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribePrice invokes the ecd.DescribePrice API synchronously
func (client *Client) DescribePrice(request *DescribePriceRequest) (response *DescribePriceResponse, err error) {
	response = CreateDescribePriceResponse()
	err = client.DoAction(request, response)
	return
}

// DescribePriceWithChan invokes the ecd.DescribePrice API asynchronously
func (client *Client) DescribePriceWithChan(request *DescribePriceRequest) (<-chan *DescribePriceResponse, <-chan error) {
	responseChan := make(chan *DescribePriceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribePrice(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribePriceWithCallback invokes the ecd.DescribePrice API asynchronously
func (client *Client) DescribePriceWithCallback(request *DescribePriceRequest, callback func(response *DescribePriceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribePriceResponse
		var err error
		defer close(result)
		response, err = client.DescribePrice(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribePriceRequest is the request struct for api DescribePrice
type DescribePriceRequest struct {
	*requests.RpcRequest
	EduTeacherBundleId       string                       `position:"Query" name:"EduTeacherBundleId"`
	SpPeriodInfo             string                       `position:"Query" name:"SpPeriodInfo"`
	RootDiskPerformanceLevel string                       `position:"Query" name:"RootDiskPerformanceLevel"`
	SpType                   string                       `position:"Query" name:"SpType"`
	GroupDesktopCount        requests.Integer             `position:"Query" name:"GroupDesktopCount"`
	NetworkType              string                       `position:"Query" name:"NetworkType"`
	UserDiskPerformanceLevel string                       `position:"Query" name:"UserDiskPerformanceLevel"`
	EduRoomClassify          string                       `position:"Query" name:"EduRoomClassify"`
	EduDesktopNum            requests.Integer             `position:"Query" name:"EduDesktopNum"`
	EduCdsEnable             string                       `position:"Query" name:"EduCdsEnable"`
	InstanceType             string                       `position:"Query" name:"InstanceType"`
	BundleModels             *[]DescribePriceBundleModels `position:"Query" name:"BundleModels"  type:"Repeated"`
	EduTeacherNum            requests.Integer             `position:"Query" name:"EduTeacherNum"`
	Period                   requests.Integer             `position:"Query" name:"Period"`
	Amount                   requests.Integer             `position:"Query" name:"Amount"`
	HardwareVersion          string                       `position:"Query" name:"HardwareVersion"`
	Bandwidth                requests.Integer             `position:"Query" name:"Bandwidth"`
	EduCommittedTime         requests.Integer             `position:"Query" name:"EduCommittedTime"`
	SpPrice                  requests.Boolean             `position:"Query" name:"SpPrice"`
	EduDesktopBundleId       string                       `position:"Query" name:"EduDesktopBundleId"`
	EduStudentBundleId       string                       `position:"Query" name:"EduStudentBundleId"`
	OsType                   string                       `position:"Query" name:"OsType"`
	EduCdsSize               requests.Integer             `position:"Query" name:"EduCdsSize"`
	ResourceType             string                       `position:"Query" name:"ResourceType"`
	PromotionId              string                       `position:"Query" name:"PromotionId"`
	UserDiskSizeGib          requests.Integer             `position:"Query" name:"UserDiskSizeGib"`
	PeriodUnit               string                       `position:"Query" name:"PeriodUnit"`
	EduStudentNum            requests.Integer             `position:"Query" name:"EduStudentNum"`
	InternetChargeType       string                       `position:"Query" name:"InternetChargeType"`
	PackageSize              requests.Integer             `position:"Query" name:"PackageSize"`
	RootDiskSizeGib          requests.Integer             `position:"Query" name:"RootDiskSizeGib"`
}

// DescribePriceBundleModels is a repeated param struct in DescribePriceRequest
type DescribePriceBundleModels struct {
	Duration     string `name:"Duration"`
	Amount       string `name:"Amount"`
	BundleId     string `name:"BundleId"`
	InstanceType string `name:"InstanceType"`
	OsType       string `name:"OsType"`
	RootDiskId   string `name:"RootDiskId"`
	UserDiskId   string `name:"UserDiskId"`
}

// DescribePriceResponse is the response struct for api DescribePrice
type DescribePriceResponse struct {
	*responses.BaseResponse
	RequestId string    `json:"RequestId" xml:"RequestId"`
	PriceInfo PriceInfo `json:"PriceInfo" xml:"PriceInfo"`
}

// CreateDescribePriceRequest creates a request to invoke DescribePrice API
func CreateDescribePriceRequest() (request *DescribePriceRequest) {
	request = &DescribePriceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "DescribePrice", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribePriceResponse creates a response to parse from DescribePrice response
func CreateDescribePriceResponse() (response *DescribePriceResponse) {
	response = &DescribePriceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
