package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeNASFileSystems invokes the ecd.DescribeNASFileSystems API synchronously
func (client *Client) DescribeNASFileSystems(request *DescribeNASFileSystemsRequest) (response *DescribeNASFileSystemsResponse, err error) {
	response = CreateDescribeNASFileSystemsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeNASFileSystemsWithChan invokes the ecd.DescribeNASFileSystems API asynchronously
func (client *Client) DescribeNASFileSystemsWithChan(request *DescribeNASFileSystemsRequest) (<-chan *DescribeNASFileSystemsResponse, <-chan error) {
	responseChan := make(chan *DescribeNASFileSystemsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeNASFileSystems(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeNASFileSystemsWithCallback invokes the ecd.DescribeNASFileSystems API asynchronously
func (client *Client) DescribeNASFileSystemsWithCallback(request *DescribeNASFileSystemsRequest, callback func(response *DescribeNASFileSystemsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeNASFileSystemsResponse
		var err error
		defer close(result)
		response, err = client.DescribeNASFileSystems(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeNASFileSystemsRequest is the request struct for api DescribeNASFileSystems
type DescribeNASFileSystemsRequest struct {
	*requests.RpcRequest
	OfficeSiteId           string           `position:"Query" name:"OfficeSiteId"`
	MatchCompatibleProfile requests.Boolean `position:"Query" name:"MatchCompatibleProfile"`
	NextToken              string           `position:"Query" name:"NextToken"`
	MaxResults             requests.Integer `position:"Query" name:"MaxResults"`
	FileSystemId           *[]string        `position:"Query" name:"FileSystemId"  type:"Repeated"`
}

// DescribeNASFileSystemsResponse is the response struct for api DescribeNASFileSystems
type DescribeNASFileSystemsResponse struct {
	*responses.BaseResponse
	NextToken   string       `json:"NextToken" xml:"NextToken"`
	RequestId   string       `json:"RequestId" xml:"RequestId"`
	FileSystems []FileSystem `json:"FileSystems" xml:"FileSystems"`
}

// CreateDescribeNASFileSystemsRequest creates a request to invoke DescribeNASFileSystems API
func CreateDescribeNASFileSystemsRequest() (request *DescribeNASFileSystemsRequest) {
	request = &DescribeNASFileSystemsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "DescribeNASFileSystems", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeNASFileSystemsResponse creates a response to parse from DescribeNASFileSystems response
func CreateDescribeNASFileSystemsResponse() (response *DescribeNASFileSystemsResponse) {
	response = &DescribeNASFileSystemsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
