package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeCdsFileShareLinks invokes the ecd.DescribeCdsFileShareLinks API synchronously
func (client *Client) DescribeCdsFileShareLinks(request *DescribeCdsFileShareLinksRequest) (response *DescribeCdsFileShareLinksResponse, err error) {
	response = CreateDescribeCdsFileShareLinksResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeCdsFileShareLinksWithChan invokes the ecd.DescribeCdsFileShareLinks API asynchronously
func (client *Client) DescribeCdsFileShareLinksWithChan(request *DescribeCdsFileShareLinksRequest) (<-chan *DescribeCdsFileShareLinksResponse, <-chan error) {
	responseChan := make(chan *DescribeCdsFileShareLinksResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeCdsFileShareLinks(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeCdsFileShareLinksWithCallback invokes the ecd.DescribeCdsFileShareLinks API asynchronously
func (client *Client) DescribeCdsFileShareLinksWithCallback(request *DescribeCdsFileShareLinksRequest, callback func(response *DescribeCdsFileShareLinksResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeCdsFileShareLinksResponse
		var err error
		defer close(result)
		response, err = client.DescribeCdsFileShareLinks(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeCdsFileShareLinksRequest is the request struct for api DescribeCdsFileShareLinks
type DescribeCdsFileShareLinksRequest struct {
	*requests.RpcRequest
	Creators   *[]string        `position:"Query" name:"Creators"  type:"Repeated"`
	ShareId    string           `position:"Query" name:"ShareId"`
	CdsId      string           `position:"Query" name:"CdsId"`
	ShareName  string           `position:"Query" name:"ShareName"`
	NextToken  string           `position:"Query" name:"NextToken"`
	MaxResults requests.Integer `position:"Query" name:"MaxResults"`
	Status     string           `position:"Query" name:"Status"`
}

// DescribeCdsFileShareLinksResponse is the response struct for api DescribeCdsFileShareLinks
type DescribeCdsFileShareLinksResponse struct {
	*responses.BaseResponse
	NextToken string                  `json:"NextToken" xml:"NextToken"`
	RequestId string                  `json:"RequestId" xml:"RequestId"`
	Success   bool                    `json:"Success" xml:"Success"`
	Code      string                  `json:"Code" xml:"Code"`
	Message   string                  `json:"Message" xml:"Message"`
	Data      []CdsFileShareLinkModel `json:"Data" xml:"Data"`
}

// CreateDescribeCdsFileShareLinksRequest creates a request to invoke DescribeCdsFileShareLinks API
func CreateDescribeCdsFileShareLinksRequest() (request *DescribeCdsFileShareLinksRequest) {
	request = &DescribeCdsFileShareLinksRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "DescribeCdsFileShareLinks", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeCdsFileShareLinksResponse creates a response to parse from DescribeCdsFileShareLinks response
func CreateDescribeCdsFileShareLinksResponse() (response *DescribeCdsFileShareLinksResponse) {
	response = &DescribeCdsFileShareLinksResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
