package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteCloudDriveGroups invokes the ecd.DeleteCloudDriveGroups API synchronously
func (client *Client) DeleteCloudDriveGroups(request *DeleteCloudDriveGroupsRequest) (response *DeleteCloudDriveGroupsResponse, err error) {
	response = CreateDeleteCloudDriveGroupsResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteCloudDriveGroupsWithChan invokes the ecd.DeleteCloudDriveGroups API asynchronously
func (client *Client) DeleteCloudDriveGroupsWithChan(request *DeleteCloudDriveGroupsRequest) (<-chan *DeleteCloudDriveGroupsResponse, <-chan error) {
	responseChan := make(chan *DeleteCloudDriveGroupsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteCloudDriveGroups(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteCloudDriveGroupsWithCallback invokes the ecd.DeleteCloudDriveGroups API asynchronously
func (client *Client) DeleteCloudDriveGroupsWithCallback(request *DeleteCloudDriveGroupsRequest, callback func(response *DeleteCloudDriveGroupsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteCloudDriveGroupsResponse
		var err error
		defer close(result)
		response, err = client.DeleteCloudDriveGroups(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteCloudDriveGroupsRequest is the request struct for api DeleteCloudDriveGroups
type DeleteCloudDriveGroupsRequest struct {
	*requests.RpcRequest
	GroupId *[]string `position:"Query" name:"GroupId"  type:"Repeated"`
	CdsId   string    `position:"Query" name:"CdsId"`
}

// DeleteCloudDriveGroupsResponse is the response struct for api DeleteCloudDriveGroups
type DeleteCloudDriveGroupsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      string `json:"Data" xml:"Data"`
	Message   string `json:"Message" xml:"Message"`
}

// CreateDeleteCloudDriveGroupsRequest creates a request to invoke DeleteCloudDriveGroups API
func CreateDeleteCloudDriveGroupsRequest() (request *DeleteCloudDriveGroupsRequest) {
	request = &DeleteCloudDriveGroupsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "DeleteCloudDriveGroups", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeleteCloudDriveGroupsResponse creates a response to parse from DeleteCloudDriveGroups response
func CreateDeleteCloudDriveGroupsResponse() (response *DeleteCloudDriveGroupsResponse) {
	response = &DeleteCloudDriveGroupsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
