package ecd

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AttachEndUser invokes the ecd.AttachEndUser API synchronously
func (client *Client) AttachEndUser(request *AttachEndUserRequest) (response *AttachEndUserResponse, err error) {
	response = CreateAttachEndUserResponse()
	err = client.DoAction(request, response)
	return
}

// AttachEndUserWithChan invokes the ecd.AttachEndUser API asynchronously
func (client *Client) AttachEndUserWithChan(request *AttachEndUserRequest) (<-chan *AttachEndUserResponse, <-chan error) {
	responseChan := make(chan *AttachEndUserResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AttachEndUser(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AttachEndUserWithCallback invokes the ecd.AttachEndUser API asynchronously
func (client *Client) AttachEndUserWithCallback(request *AttachEndUserRequest, callback func(response *AttachEndUserResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AttachEndUserResponse
		var err error
		defer close(result)
		response, err = client.AttachEndUser(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AttachEndUserRequest is the request struct for api AttachEndUser
type AttachEndUserRequest struct {
	*requests.RpcRequest
	ClientType  requests.Integer `position:"Query" name:"ClientType"`
	UserType    string           `position:"Query" name:"UserType"`
	DeviceId    string           `position:"Query" name:"DeviceId"`
	AdDomain    string           `position:"Query" name:"AdDomain"`
	EndUserId   string           `position:"Query" name:"EndUserId"`
	DirectoryId string           `position:"Query" name:"DirectoryId"`
}

// AttachEndUserResponse is the response struct for api AttachEndUser
type AttachEndUserResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAttachEndUserRequest creates a request to invoke AttachEndUser API
func CreateAttachEndUserRequest() (request *AttachEndUserRequest) {
	request = &AttachEndUserRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ecd", "2020-09-30", "AttachEndUser", "gwsecd", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAttachEndUserResponse creates a response to parse from AttachEndUser response
func CreateAttachEndUserResponse() (response *AttachEndUserResponse) {
	response = &AttachEndUserResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
