package ebs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddDiskReplicaPair invokes the ebs.AddDiskReplicaPair API synchronously
func (client *Client) AddDiskReplicaPair(request *AddDiskReplicaPairRequest) (response *AddDiskReplicaPairResponse, err error) {
	response = CreateAddDiskReplicaPairResponse()
	err = client.DoAction(request, response)
	return
}

// AddDiskReplicaPairWithChan invokes the ebs.AddDiskReplicaPair API asynchronously
func (client *Client) AddDiskReplicaPairWithChan(request *AddDiskReplicaPairRequest) (<-chan *AddDiskReplicaPairResponse, <-chan error) {
	responseChan := make(chan *AddDiskReplicaPairResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddDiskReplicaPair(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddDiskReplicaPairWithCallback invokes the ebs.AddDiskReplicaPair API asynchronously
func (client *Client) AddDiskReplicaPairWithCallback(request *AddDiskReplicaPairRequest, callback func(response *AddDiskReplicaPairResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddDiskReplicaPairResponse
		var err error
		defer close(result)
		response, err = client.AddDiskReplicaPair(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddDiskReplicaPairRequest is the request struct for api AddDiskReplicaPair
type AddDiskReplicaPairRequest struct {
	*requests.RpcRequest
	ClientToken    string `position:"Query" name:"ClientToken"`
	ReplicaGroupId string `position:"Query" name:"ReplicaGroupId"`
	ReplicaPairId  string `position:"Query" name:"ReplicaPairId"`
}

// AddDiskReplicaPairResponse is the response struct for api AddDiskReplicaPair
type AddDiskReplicaPairResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAddDiskReplicaPairRequest creates a request to invoke AddDiskReplicaPair API
func CreateAddDiskReplicaPairRequest() (request *AddDiskReplicaPairRequest) {
	request = &AddDiskReplicaPairRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ebs", "2021-07-30", "AddDiskReplicaPair", "ebs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateAddDiskReplicaPairResponse creates a response to parse from AddDiskReplicaPair response
func CreateAddDiskReplicaPairResponse() (response *AddDiskReplicaPairResponse) {
	response = &AddDiskReplicaPairResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
