package dytnsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribePhoneNumberAnalysis invokes the dytnsapi.DescribePhoneNumberAnalysis API synchronously
func (client *Client) DescribePhoneNumberAnalysis(request *DescribePhoneNumberAnalysisRequest) (response *DescribePhoneNumberAnalysisResponse, err error) {
	response = CreateDescribePhoneNumberAnalysisResponse()
	err = client.DoAction(request, response)
	return
}

// DescribePhoneNumberAnalysisWithChan invokes the dytnsapi.DescribePhoneNumberAnalysis API asynchronously
func (client *Client) DescribePhoneNumberAnalysisWithChan(request *DescribePhoneNumberAnalysisRequest) (<-chan *DescribePhoneNumberAnalysisResponse, <-chan error) {
	responseChan := make(chan *DescribePhoneNumberAnalysisResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribePhoneNumberAnalysis(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribePhoneNumberAnalysisWithCallback invokes the dytnsapi.DescribePhoneNumberAnalysis API asynchronously
func (client *Client) DescribePhoneNumberAnalysisWithCallback(request *DescribePhoneNumberAnalysisRequest, callback func(response *DescribePhoneNumberAnalysisResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribePhoneNumberAnalysisResponse
		var err error
		defer close(result)
		response, err = client.DescribePhoneNumberAnalysis(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribePhoneNumberAnalysisRequest is the request struct for api DescribePhoneNumberAnalysis
type DescribePhoneNumberAnalysisRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ExtendFunction       string           `position:"Query" name:"ExtendFunction"`
	Rate                 requests.Integer `position:"Query" name:"Rate"`
	RouteName            string           `position:"Query" name:"RouteName"`
	Mask                 string           `position:"Query" name:"Mask"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	NumberType           requests.Integer `position:"Query" name:"NumberType"`
	AuthCode             string           `position:"Query" name:"AuthCode"`
	InputNumber          string           `position:"Query" name:"InputNumber"`
}

// DescribePhoneNumberAnalysisResponse is the response struct for api DescribePhoneNumberAnalysis
type DescribePhoneNumberAnalysisResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	Code      string `json:"Code" xml:"Code"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateDescribePhoneNumberAnalysisRequest creates a request to invoke DescribePhoneNumberAnalysis API
func CreateDescribePhoneNumberAnalysisRequest() (request *DescribePhoneNumberAnalysisRequest) {
	request = &DescribePhoneNumberAnalysisRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dytnsapi", "2020-02-17", "DescribePhoneNumberAnalysis", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribePhoneNumberAnalysisResponse creates a response to parse from DescribePhoneNumberAnalysis response
func CreateDescribePhoneNumberAnalysisResponse() (response *DescribePhoneNumberAnalysisResponse) {
	response = &DescribePhoneNumberAnalysisResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
