package dypnsapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// VerifyPhoneWithToken invokes the dypnsapi.VerifyPhoneWithToken API synchronously
func (client *Client) VerifyPhoneWithToken(request *VerifyPhoneWithTokenRequest) (response *VerifyPhoneWithTokenResponse, err error) {
	response = CreateVerifyPhoneWithTokenResponse()
	err = client.DoAction(request, response)
	return
}

// VerifyPhoneWithTokenWithChan invokes the dypnsapi.VerifyPhoneWithToken API asynchronously
func (client *Client) VerifyPhoneWithTokenWithChan(request *VerifyPhoneWithTokenRequest) (<-chan *VerifyPhoneWithTokenResponse, <-chan error) {
	responseChan := make(chan *VerifyPhoneWithTokenResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.VerifyPhoneWithToken(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// VerifyPhoneWithTokenWithCallback invokes the dypnsapi.VerifyPhoneWithToken API asynchronously
func (client *Client) VerifyPhoneWithTokenWithCallback(request *VerifyPhoneWithTokenRequest, callback func(response *VerifyPhoneWithTokenResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *VerifyPhoneWithTokenResponse
		var err error
		defer close(result)
		response, err = client.VerifyPhoneWithToken(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// VerifyPhoneWithTokenRequest is the request struct for api VerifyPhoneWithToken
type VerifyPhoneWithTokenRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	PhoneNumber          string           `position:"Query" name:"PhoneNumber"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	SpToken              string           `position:"Query" name:"SpToken"`
}

// VerifyPhoneWithTokenResponse is the response struct for api VerifyPhoneWithToken
type VerifyPhoneWithTokenResponse struct {
	*responses.BaseResponse
	Code       string     `json:"Code" xml:"Code"`
	Message    string     `json:"Message" xml:"Message"`
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	GateVerify GateVerify `json:"GateVerify" xml:"GateVerify"`
}

// CreateVerifyPhoneWithTokenRequest creates a request to invoke VerifyPhoneWithToken API
func CreateVerifyPhoneWithTokenRequest() (request *VerifyPhoneWithTokenRequest) {
	request = &VerifyPhoneWithTokenRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Dypnsapi", "2017-05-25", "VerifyPhoneWithToken", "dypnsapi", "openAPI")
	request.Method = requests.POST
	return
}

// CreateVerifyPhoneWithTokenResponse creates a response to parse from VerifyPhoneWithToken response
func CreateVerifyPhoneWithTokenResponse() (response *VerifyPhoneWithTokenResponse) {
	response = &VerifyPhoneWithTokenResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
