package dt_oc_info

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetOcJusticeCourtAnnouncement invokes the dt_oc_info.GetOcJusticeCourtAnnouncement API synchronously
func (client *Client) GetOcJusticeCourtAnnouncement(request *GetOcJusticeCourtAnnouncementRequest) (response *GetOcJusticeCourtAnnouncementResponse, err error) {
	response = CreateGetOcJusticeCourtAnnouncementResponse()
	err = client.DoAction(request, response)
	return
}

// GetOcJusticeCourtAnnouncementWithChan invokes the dt_oc_info.GetOcJusticeCourtAnnouncement API asynchronously
func (client *Client) GetOcJusticeCourtAnnouncementWithChan(request *GetOcJusticeCourtAnnouncementRequest) (<-chan *GetOcJusticeCourtAnnouncementResponse, <-chan error) {
	responseChan := make(chan *GetOcJusticeCourtAnnouncementResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetOcJusticeCourtAnnouncement(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetOcJusticeCourtAnnouncementWithCallback invokes the dt_oc_info.GetOcJusticeCourtAnnouncement API asynchronously
func (client *Client) GetOcJusticeCourtAnnouncementWithCallback(request *GetOcJusticeCourtAnnouncementRequest, callback func(response *GetOcJusticeCourtAnnouncementResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetOcJusticeCourtAnnouncementResponse
		var err error
		defer close(result)
		response, err = client.GetOcJusticeCourtAnnouncement(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetOcJusticeCourtAnnouncementRequest is the request struct for api GetOcJusticeCourtAnnouncement
type GetOcJusticeCourtAnnouncementRequest struct {
	*requests.RpcRequest
	PageNo    requests.Integer `position:"Body" name:"PageNo"`
	PageSize  requests.Integer `position:"Body" name:"PageSize"`
	SearchKey string           `position:"Body" name:"SearchKey"`
}

// GetOcJusticeCourtAnnouncementResponse is the response struct for api GetOcJusticeCourtAnnouncement
type GetOcJusticeCourtAnnouncementResponse struct {
	*responses.BaseResponse
	Code      string     `json:"Code" xml:"Code"`
	Success   bool       `json:"Success" xml:"Success"`
	Message   string     `json:"Message" xml:"Message"`
	TotalNum  int        `json:"TotalNum" xml:"TotalNum"`
	PageIndex int        `json:"PageIndex" xml:"PageIndex"`
	PageNum   int        `json:"PageNum" xml:"PageNum"`
	RequestId string     `json:"RequestId" xml:"RequestId"`
	Data      []DataItem `json:"Data" xml:"Data"`
}

// CreateGetOcJusticeCourtAnnouncementRequest creates a request to invoke GetOcJusticeCourtAnnouncement API
func CreateGetOcJusticeCourtAnnouncementRequest() (request *GetOcJusticeCourtAnnouncementRequest) {
	request = &GetOcJusticeCourtAnnouncementRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dt-oc-info", "2022-08-29", "GetOcJusticeCourtAnnouncement", "", "")
	request.Method = requests.POST
	return
}

// CreateGetOcJusticeCourtAnnouncementResponse creates a response to parse from GetOcJusticeCourtAnnouncement response
func CreateGetOcJusticeCourtAnnouncementResponse() (response *GetOcJusticeCourtAnnouncementResponse) {
	response = &GetOcJusticeCourtAnnouncementResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
