package domain

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// SaveSingleTaskForApplyQuickTransferOutOpenly invokes the domain.SaveSingleTaskForApplyQuickTransferOutOpenly API synchronously
func (client *Client) SaveSingleTaskForApplyQuickTransferOutOpenly(request *SaveSingleTaskForApplyQuickTransferOutOpenlyRequest) (response *SaveSingleTaskForApplyQuickTransferOutOpenlyResponse, err error) {
	response = CreateSaveSingleTaskForApplyQuickTransferOutOpenlyResponse()
	err = client.DoAction(request, response)
	return
}

// SaveSingleTaskForApplyQuickTransferOutOpenlyWithChan invokes the domain.SaveSingleTaskForApplyQuickTransferOutOpenly API asynchronously
func (client *Client) SaveSingleTaskForApplyQuickTransferOutOpenlyWithChan(request *SaveSingleTaskForApplyQuickTransferOutOpenlyRequest) (<-chan *SaveSingleTaskForApplyQuickTransferOutOpenlyResponse, <-chan error) {
	responseChan := make(chan *SaveSingleTaskForApplyQuickTransferOutOpenlyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.SaveSingleTaskForApplyQuickTransferOutOpenly(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// SaveSingleTaskForApplyQuickTransferOutOpenlyWithCallback invokes the domain.SaveSingleTaskForApplyQuickTransferOutOpenly API asynchronously
func (client *Client) SaveSingleTaskForApplyQuickTransferOutOpenlyWithCallback(request *SaveSingleTaskForApplyQuickTransferOutOpenlyRequest, callback func(response *SaveSingleTaskForApplyQuickTransferOutOpenlyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *SaveSingleTaskForApplyQuickTransferOutOpenlyResponse
		var err error
		defer close(result)
		response, err = client.SaveSingleTaskForApplyQuickTransferOutOpenly(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// SaveSingleTaskForApplyQuickTransferOutOpenlyRequest is the request struct for api SaveSingleTaskForApplyQuickTransferOutOpenly
type SaveSingleTaskForApplyQuickTransferOutOpenlyRequest struct {
	*requests.RpcRequest
	DomainName   string `position:"Query" name:"DomainName"`
	UserClientIp string `position:"Query" name:"UserClientIp"`
	Lang         string `position:"Query" name:"Lang"`
}

// SaveSingleTaskForApplyQuickTransferOutOpenlyResponse is the response struct for api SaveSingleTaskForApplyQuickTransferOutOpenly
type SaveSingleTaskForApplyQuickTransferOutOpenlyResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	TaskNo    string `json:"TaskNo" xml:"TaskNo"`
}

// CreateSaveSingleTaskForApplyQuickTransferOutOpenlyRequest creates a request to invoke SaveSingleTaskForApplyQuickTransferOutOpenly API
func CreateSaveSingleTaskForApplyQuickTransferOutOpenlyRequest() (request *SaveSingleTaskForApplyQuickTransferOutOpenlyRequest) {
	request = &SaveSingleTaskForApplyQuickTransferOutOpenlyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Domain", "2018-01-29", "SaveSingleTaskForApplyQuickTransferOutOpenly", "domain", "openAPI")
	request.Method = requests.POST
	return
}

// CreateSaveSingleTaskForApplyQuickTransferOutOpenlyResponse creates a response to parse from SaveSingleTaskForApplyQuickTransferOutOpenly response
func CreateSaveSingleTaskForApplyQuickTransferOutOpenlyResponse() (response *SaveSingleTaskForApplyQuickTransferOutOpenlyResponse) {
	response = &SaveSingleTaskForApplyQuickTransferOutOpenlyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
