package documentautoml

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateModelAsyncPredict invokes the documentautoml.CreateModelAsyncPredict API synchronously
func (client *Client) CreateModelAsyncPredict(request *CreateModelAsyncPredictRequest) (response *CreateModelAsyncPredictResponse, err error) {
	response = CreateCreateModelAsyncPredictResponse()
	err = client.DoAction(request, response)
	return
}

// CreateModelAsyncPredictWithChan invokes the documentautoml.CreateModelAsyncPredict API asynchronously
func (client *Client) CreateModelAsyncPredictWithChan(request *CreateModelAsyncPredictRequest) (<-chan *CreateModelAsyncPredictResponse, <-chan error) {
	responseChan := make(chan *CreateModelAsyncPredictResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateModelAsyncPredict(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateModelAsyncPredictWithCallback invokes the documentautoml.CreateModelAsyncPredict API asynchronously
func (client *Client) CreateModelAsyncPredictWithCallback(request *CreateModelAsyncPredictRequest, callback func(response *CreateModelAsyncPredictResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateModelAsyncPredictResponse
		var err error
		defer close(result)
		response, err = client.CreateModelAsyncPredict(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateModelAsyncPredictRequest is the request struct for api CreateModelAsyncPredict
type CreateModelAsyncPredictRequest struct {
	*requests.RpcRequest
	Body           string           `position:"Body" name:"body"`
	BinaryToText   requests.Boolean `position:"Query" name:"BinaryToText"`
	Content        string           `position:"Query" name:"Content"`
	ServiceName    string           `position:"Query" name:"ServiceName"`
	Product        string           `position:"Query" name:"Product"`
	ModelId        requests.Integer `position:"Query" name:"ModelId"`
	ServiceVersion string           `position:"Query" name:"ServiceVersion"`
	ModelVersion   string           `position:"Query" name:"ModelVersion"`
}

// CreateModelAsyncPredictResponse is the response struct for api CreateModelAsyncPredict
type CreateModelAsyncPredictResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	Data      string `json:"Data" xml:"Data"`
}

// CreateCreateModelAsyncPredictRequest creates a request to invoke CreateModelAsyncPredict API
func CreateCreateModelAsyncPredictRequest() (request *CreateModelAsyncPredictRequest) {
	request = &CreateModelAsyncPredictRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("documentAutoml", "2022-12-29", "CreateModelAsyncPredict", "documentAutoml", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateModelAsyncPredictResponse creates a response to parse from CreateModelAsyncPredict response
func CreateCreateModelAsyncPredictResponse() (response *CreateModelAsyncPredictResponse) {
	response = &CreateModelAsyncPredictResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
