package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListSQLReviewOriginSQL invokes the dms_enterprise.ListSQLReviewOriginSQL API synchronously
func (client *Client) ListSQLReviewOriginSQL(request *ListSQLReviewOriginSQLRequest) (response *ListSQLReviewOriginSQLResponse, err error) {
	response = CreateListSQLReviewOriginSQLResponse()
	err = client.DoAction(request, response)
	return
}

// ListSQLReviewOriginSQLWithChan invokes the dms_enterprise.ListSQLReviewOriginSQL API asynchronously
func (client *Client) ListSQLReviewOriginSQLWithChan(request *ListSQLReviewOriginSQLRequest) (<-chan *ListSQLReviewOriginSQLResponse, <-chan error) {
	responseChan := make(chan *ListSQLReviewOriginSQLResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListSQLReviewOriginSQL(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListSQLReviewOriginSQLWithCallback invokes the dms_enterprise.ListSQLReviewOriginSQL API asynchronously
func (client *Client) ListSQLReviewOriginSQLWithCallback(request *ListSQLReviewOriginSQLRequest, callback func(response *ListSQLReviewOriginSQLResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListSQLReviewOriginSQLResponse
		var err error
		defer close(result)
		response, err = client.ListSQLReviewOriginSQL(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListSQLReviewOriginSQLRequest is the request struct for api ListSQLReviewOriginSQL
type ListSQLReviewOriginSQLRequest struct {
	*requests.RpcRequest
	Tid               requests.Integer                        `position:"Query" name:"Tid"`
	OrderId           requests.Integer                        `position:"Query" name:"OrderId"`
	OrderActionDetail ListSQLReviewOriginSQLOrderActionDetail `position:"Query" name:"OrderActionDetail"  type:"Struct"`
	OrderActionName   string                                  `position:"Query" name:"OrderActionName"`
}

// ListSQLReviewOriginSQLOrderActionDetail is a repeated param struct in ListSQLReviewOriginSQLRequest
type ListSQLReviewOriginSQLOrderActionDetail struct {
	CheckStatusResult string                                      `name:"CheckStatusResult"`
	SQLReviewResult   string                                      `name:"SQLReviewResult"`
	Page              ListSQLReviewOriginSQLOrderActionDetailPage `name:"Page" type:"Struct"`
	FileId            string                                      `name:"FileId"`
}

// ListSQLReviewOriginSQLOrderActionDetailPage is a repeated param struct in ListSQLReviewOriginSQLRequest
type ListSQLReviewOriginSQLOrderActionDetailPage struct {
	PageSize   string `name:"PageSize"`
	PageNumber string `name:"PageNumber"`
}

// ListSQLReviewOriginSQLResponse is the response struct for api ListSQLReviewOriginSQL
type ListSQLReviewOriginSQLResponse struct {
	*responses.BaseResponse
	RequestId     string              `json:"RequestId" xml:"RequestId"`
	ErrorCode     string              `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage  string              `json:"ErrorMessage" xml:"ErrorMessage"`
	Success       bool                `json:"Success" xml:"Success"`
	TotalCount    int                 `json:"TotalCount" xml:"TotalCount"`
	OriginSQLList []OriginSQLListItem `json:"OriginSQLList" xml:"OriginSQLList"`
}

// CreateListSQLReviewOriginSQLRequest creates a request to invoke ListSQLReviewOriginSQL API
func CreateListSQLReviewOriginSQLRequest() (request *ListSQLReviewOriginSQLRequest) {
	request = &ListSQLReviewOriginSQLRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "ListSQLReviewOriginSQL", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListSQLReviewOriginSQLResponse creates a response to parse from ListSQLReviewOriginSQL response
func CreateListSQLReviewOriginSQLResponse() (response *ListSQLReviewOriginSQLResponse) {
	response = &ListSQLReviewOriginSQLResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
