package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListAuthorizedUsersForInstance invokes the dms_enterprise.ListAuthorizedUsersForInstance API synchronously
func (client *Client) ListAuthorizedUsersForInstance(request *ListAuthorizedUsersForInstanceRequest) (response *ListAuthorizedUsersForInstanceResponse, err error) {
	response = CreateListAuthorizedUsersForInstanceResponse()
	err = client.DoAction(request, response)
	return
}

// ListAuthorizedUsersForInstanceWithChan invokes the dms_enterprise.ListAuthorizedUsersForInstance API asynchronously
func (client *Client) ListAuthorizedUsersForInstanceWithChan(request *ListAuthorizedUsersForInstanceRequest) (<-chan *ListAuthorizedUsersForInstanceResponse, <-chan error) {
	responseChan := make(chan *ListAuthorizedUsersForInstanceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListAuthorizedUsersForInstance(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListAuthorizedUsersForInstanceWithCallback invokes the dms_enterprise.ListAuthorizedUsersForInstance API asynchronously
func (client *Client) ListAuthorizedUsersForInstanceWithCallback(request *ListAuthorizedUsersForInstanceRequest, callback func(response *ListAuthorizedUsersForInstanceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListAuthorizedUsersForInstanceResponse
		var err error
		defer close(result)
		response, err = client.ListAuthorizedUsersForInstance(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListAuthorizedUsersForInstanceRequest is the request struct for api ListAuthorizedUsersForInstance
type ListAuthorizedUsersForInstanceRequest struct {
	*requests.RpcRequest
	SearchKey  string           `position:"Query" name:"SearchKey"`
	PageNumber string           `position:"Query" name:"PageNumber"`
	Tid        requests.Integer `position:"Query" name:"Tid"`
	PageSize   string           `position:"Query" name:"PageSize"`
	InstanceId string           `position:"Query" name:"InstanceId"`
}

// ListAuthorizedUsersForInstanceResponse is the response struct for api ListAuthorizedUsersForInstance
type ListAuthorizedUsersForInstanceResponse struct {
	*responses.BaseResponse
	RequestId string      `json:"RequestId" xml:"RequestId"`
	Users     []UsersItem `json:"Users" xml:"Users"`
}

// CreateListAuthorizedUsersForInstanceRequest creates a request to invoke ListAuthorizedUsersForInstance API
func CreateListAuthorizedUsersForInstanceRequest() (request *ListAuthorizedUsersForInstanceRequest) {
	request = &ListAuthorizedUsersForInstanceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "ListAuthorizedUsersForInstance", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListAuthorizedUsersForInstanceResponse creates a response to parse from ListAuthorizedUsersForInstance response
func CreateListAuthorizedUsersForInstanceResponse() (response *ListAuthorizedUsersForInstanceResponse) {
	response = &ListAuthorizedUsersForInstanceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
