package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetDataExportPreCheckDetail invokes the dms_enterprise.GetDataExportPreCheckDetail API synchronously
func (client *Client) GetDataExportPreCheckDetail(request *GetDataExportPreCheckDetailRequest) (response *GetDataExportPreCheckDetailResponse, err error) {
	response = CreateGetDataExportPreCheckDetailResponse()
	err = client.DoAction(request, response)
	return
}

// GetDataExportPreCheckDetailWithChan invokes the dms_enterprise.GetDataExportPreCheckDetail API asynchronously
func (client *Client) GetDataExportPreCheckDetailWithChan(request *GetDataExportPreCheckDetailRequest) (<-chan *GetDataExportPreCheckDetailResponse, <-chan error) {
	responseChan := make(chan *GetDataExportPreCheckDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetDataExportPreCheckDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetDataExportPreCheckDetailWithCallback invokes the dms_enterprise.GetDataExportPreCheckDetail API asynchronously
func (client *Client) GetDataExportPreCheckDetailWithCallback(request *GetDataExportPreCheckDetailRequest, callback func(response *GetDataExportPreCheckDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetDataExportPreCheckDetailResponse
		var err error
		defer close(result)
		response, err = client.GetDataExportPreCheckDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetDataExportPreCheckDetailRequest is the request struct for api GetDataExportPreCheckDetail
type GetDataExportPreCheckDetailRequest struct {
	*requests.RpcRequest
	Tid     requests.Integer `position:"Query" name:"Tid"`
	OrderId requests.Integer `position:"Query" name:"OrderId"`
}

// GetDataExportPreCheckDetailResponse is the response struct for api GetDataExportPreCheckDetail
type GetDataExportPreCheckDetailResponse struct {
	*responses.BaseResponse
	RequestId      string         `json:"RequestId" xml:"RequestId"`
	ErrorCode      string         `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage   string         `json:"ErrorMessage" xml:"ErrorMessage"`
	Success        bool           `json:"Success" xml:"Success"`
	PreCheckResult PreCheckResult `json:"PreCheckResult" xml:"PreCheckResult"`
}

// CreateGetDataExportPreCheckDetailRequest creates a request to invoke GetDataExportPreCheckDetail API
func CreateGetDataExportPreCheckDetailRequest() (request *GetDataExportPreCheckDetailRequest) {
	request = &GetDataExportPreCheckDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "GetDataExportPreCheckDetail", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetDataExportPreCheckDetailResponse creates a response to parse from GetDataExportPreCheckDetail response
func CreateGetDataExportPreCheckDetailResponse() (response *GetDataExportPreCheckDetailResponse) {
	response = &GetDataExportPreCheckDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
