package dms_enterprise

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateDatabaseExportOrder invokes the dms_enterprise.CreateDatabaseExportOrder API synchronously
func (client *Client) CreateDatabaseExportOrder(request *CreateDatabaseExportOrderRequest) (response *CreateDatabaseExportOrderResponse, err error) {
	response = CreateCreateDatabaseExportOrderResponse()
	err = client.DoAction(request, response)
	return
}

// CreateDatabaseExportOrderWithChan invokes the dms_enterprise.CreateDatabaseExportOrder API asynchronously
func (client *Client) CreateDatabaseExportOrderWithChan(request *CreateDatabaseExportOrderRequest) (<-chan *CreateDatabaseExportOrderResponse, <-chan error) {
	responseChan := make(chan *CreateDatabaseExportOrderResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateDatabaseExportOrder(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateDatabaseExportOrderWithCallback invokes the dms_enterprise.CreateDatabaseExportOrder API asynchronously
func (client *Client) CreateDatabaseExportOrderWithCallback(request *CreateDatabaseExportOrderRequest, callback func(response *CreateDatabaseExportOrderResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateDatabaseExportOrderResponse
		var err error
		defer close(result)
		response, err = client.CreateDatabaseExportOrder(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateDatabaseExportOrderRequest is the request struct for api CreateDatabaseExportOrder
type CreateDatabaseExportOrderRequest struct {
	*requests.RpcRequest
	ParentId        requests.Integer                     `position:"Query" name:"ParentId"`
	Tid             requests.Integer                     `position:"Query" name:"Tid"`
	RelatedUserList *[]string                            `position:"Query" name:"RelatedUserList"  type:"Json"`
	PluginParam     CreateDatabaseExportOrderPluginParam `position:"Query" name:"PluginParam"  type:"Struct"`
	AttachmentKey   string                               `position:"Query" name:"AttachmentKey"`
	Comment         string                               `position:"Query" name:"Comment"`
}

// CreateDatabaseExportOrderPluginParam is a repeated param struct in CreateDatabaseExportOrderRequest
type CreateDatabaseExportOrderPluginParam struct {
	Classify   string                                     `name:"Classify"`
	SearchName string                                     `name:"SearchName"`
	InstanceId string                                     `name:"InstanceId"`
	DbId       string                                     `name:"DbId"`
	Logic      string                                     `name:"Logic"`
	Config     CreateDatabaseExportOrderPluginParamConfig `name:"Config" type:"Struct"`
}

// CreateDatabaseExportOrderPluginParamConfig is a repeated param struct in CreateDatabaseExportOrderRequest
type CreateDatabaseExportOrderPluginParamConfig struct {
	TargetOption   string            `name:"TargetOption"`
	DataOption     *[]string         `name:"DataOption" type:"Repeated"`
	Tables         map[string]string `name:"Tables" type:"Map"`
	ExportContent  string            `name:"ExportContent"`
	SelectedTables *[]string         `name:"SelectedTables" type:"Repeated"`
	ExportTypes    *[]string         `name:"ExportTypes" type:"Repeated"`
	SQLExtOption   *[]string         `name:"SQLExtOption" type:"Repeated"`
}

// CreateDatabaseExportOrderResponse is the response struct for api CreateDatabaseExportOrder
type CreateDatabaseExportOrderResponse struct {
	*responses.BaseResponse
	RequestId         string                                       `json:"RequestId" xml:"RequestId"`
	ErrorCode         string                                       `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage      string                                       `json:"ErrorMessage" xml:"ErrorMessage"`
	Success           bool                                         `json:"Success" xml:"Success"`
	CreateOrderResult CreateOrderResultInCreateDatabaseExportOrder `json:"CreateOrderResult" xml:"CreateOrderResult"`
}

// CreateCreateDatabaseExportOrderRequest creates a request to invoke CreateDatabaseExportOrder API
func CreateCreateDatabaseExportOrderRequest() (request *CreateDatabaseExportOrderRequest) {
	request = &CreateDatabaseExportOrderRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dms-enterprise", "2018-11-01", "CreateDatabaseExportOrder", "dms-enterprise", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateDatabaseExportOrderResponse creates a response to parse from CreateDatabaseExportOrder response
func CreateCreateDatabaseExportOrderResponse() (response *CreateDatabaseExportOrderResponse) {
	response = &CreateDatabaseExportOrderResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
