package dfs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetRegion invokes the dfs.GetRegion API synchronously
func (client *Client) GetRegion(request *GetRegionRequest) (response *GetRegionResponse, err error) {
	response = CreateGetRegionResponse()
	err = client.DoAction(request, response)
	return
}

// GetRegionWithChan invokes the dfs.GetRegion API asynchronously
func (client *Client) GetRegionWithChan(request *GetRegionRequest) (<-chan *GetRegionResponse, <-chan error) {
	responseChan := make(chan *GetRegionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetRegion(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetRegionWithCallback invokes the dfs.GetRegion API asynchronously
func (client *Client) GetRegionWithCallback(request *GetRegionRequest, callback func(response *GetRegionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetRegionResponse
		var err error
		defer close(result)
		response, err = client.GetRegion(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetRegionRequest is the request struct for api GetRegion
type GetRegionRequest struct {
	*requests.RpcRequest
	InputRegionId string `position:"Query" name:"InputRegionId"`
}

// GetRegionResponse is the response struct for api GetRegion
type GetRegionResponse struct {
	*responses.BaseResponse
	RequestId      string          `json:"RequestId" xml:"RequestId"`
	AvailableZones []AvailableZone `json:"AvailableZones" xml:"AvailableZones"`
}

// CreateGetRegionRequest creates a request to invoke GetRegion API
func CreateGetRegionRequest() (request *GetRegionRequest) {
	request = &GetRegionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DFS", "2018-06-20", "GetRegion", "alidfs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetRegionResponse creates a response to parse from GetRegion response
func CreateGetRegionResponse() (response *GetRegionResponse) {
	response = &GetRegionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
