package dfs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetAccessRule invokes the dfs.GetAccessRule API synchronously
func (client *Client) GetAccessRule(request *GetAccessRuleRequest) (response *GetAccessRuleResponse, err error) {
	response = CreateGetAccessRuleResponse()
	err = client.DoAction(request, response)
	return
}

// GetAccessRuleWithChan invokes the dfs.GetAccessRule API asynchronously
func (client *Client) GetAccessRuleWithChan(request *GetAccessRuleRequest) (<-chan *GetAccessRuleResponse, <-chan error) {
	responseChan := make(chan *GetAccessRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetAccessRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetAccessRuleWithCallback invokes the dfs.GetAccessRule API asynchronously
func (client *Client) GetAccessRuleWithCallback(request *GetAccessRuleRequest, callback func(response *GetAccessRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetAccessRuleResponse
		var err error
		defer close(result)
		response, err = client.GetAccessRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetAccessRuleRequest is the request struct for api GetAccessRule
type GetAccessRuleRequest struct {
	*requests.RpcRequest
	AccessGroupId string `position:"Query" name:"AccessGroupId"`
	InputRegionId string `position:"Query" name:"InputRegionId"`
	AccessRuleId  string `position:"Query" name:"AccessRuleId"`
}

// GetAccessRuleResponse is the response struct for api GetAccessRule
type GetAccessRuleResponse struct {
	*responses.BaseResponse
	RequestId  string     `json:"RequestId" xml:"RequestId"`
	AccessRule AccessRule `json:"AccessRule" xml:"AccessRule"`
}

// CreateGetAccessRuleRequest creates a request to invoke GetAccessRule API
func CreateGetAccessRuleRequest() (request *GetAccessRuleRequest) {
	request = &GetAccessRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("DFS", "2018-06-20", "GetAccessRule", "alidfs", "openAPI")
	request.Method = requests.POST
	return
}

// CreateGetAccessRuleResponse creates a response to parse from GetAccessRule response
func CreateGetAccessRuleResponse() (response *GetAccessRuleResponse) {
	response = &GetAccessRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
