package ddoscoo

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeBlockStatus invokes the ddoscoo.DescribeBlockStatus API synchronously
func (client *Client) DescribeBlockStatus(request *DescribeBlockStatusRequest) (response *DescribeBlockStatusResponse, err error) {
	response = CreateDescribeBlockStatusResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeBlockStatusWithChan invokes the ddoscoo.DescribeBlockStatus API asynchronously
func (client *Client) DescribeBlockStatusWithChan(request *DescribeBlockStatusRequest) (<-chan *DescribeBlockStatusResponse, <-chan error) {
	responseChan := make(chan *DescribeBlockStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeBlockStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeBlockStatusWithCallback invokes the ddoscoo.DescribeBlockStatus API asynchronously
func (client *Client) DescribeBlockStatusWithCallback(request *DescribeBlockStatusRequest, callback func(response *DescribeBlockStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeBlockStatusResponse
		var err error
		defer close(result)
		response, err = client.DescribeBlockStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeBlockStatusRequest is the request struct for api DescribeBlockStatus
type DescribeBlockStatusRequest struct {
	*requests.RpcRequest
	ResourceGroupId string    `position:"Query" name:"ResourceGroupId"`
	SourceIp        string    `position:"Query" name:"SourceIp"`
	InstanceIds     *[]string `position:"Query" name:"InstanceIds"  type:"Repeated"`
	Lang            string    `position:"Query" name:"Lang"`
}

// DescribeBlockStatusResponse is the response struct for api DescribeBlockStatus
type DescribeBlockStatusResponse struct {
	*responses.BaseResponse
	RequestId  string       `json:"RequestId" xml:"RequestId"`
	StatusList []StatusItem `json:"StatusList" xml:"StatusList"`
}

// CreateDescribeBlockStatusRequest creates a request to invoke DescribeBlockStatus API
func CreateDescribeBlockStatusRequest() (request *DescribeBlockStatusRequest) {
	request = &DescribeBlockStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ddoscoo", "2020-01-01", "DescribeBlockStatus", "ddoscoo", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeBlockStatusResponse creates a response to parse from DescribeBlockStatus response
func CreateDescribeBlockStatusResponse() (response *DescribeBlockStatusResponse) {
	response = &DescribeBlockStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
