package dcdn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDcdnDomainHttpCodeData invokes the dcdn.DescribeDcdnDomainHttpCodeData API synchronously
func (client *Client) DescribeDcdnDomainHttpCodeData(request *DescribeDcdnDomainHttpCodeDataRequest) (response *DescribeDcdnDomainHttpCodeDataResponse, err error) {
	response = CreateDescribeDcdnDomainHttpCodeDataResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDcdnDomainHttpCodeDataWithChan invokes the dcdn.DescribeDcdnDomainHttpCodeData API asynchronously
func (client *Client) DescribeDcdnDomainHttpCodeDataWithChan(request *DescribeDcdnDomainHttpCodeDataRequest) (<-chan *DescribeDcdnDomainHttpCodeDataResponse, <-chan error) {
	responseChan := make(chan *DescribeDcdnDomainHttpCodeDataResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDcdnDomainHttpCodeData(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDcdnDomainHttpCodeDataWithCallback invokes the dcdn.DescribeDcdnDomainHttpCodeData API asynchronously
func (client *Client) DescribeDcdnDomainHttpCodeDataWithCallback(request *DescribeDcdnDomainHttpCodeDataRequest, callback func(response *DescribeDcdnDomainHttpCodeDataResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDcdnDomainHttpCodeDataResponse
		var err error
		defer close(result)
		response, err = client.DescribeDcdnDomainHttpCodeData(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDcdnDomainHttpCodeDataRequest is the request struct for api DescribeDcdnDomainHttpCodeData
type DescribeDcdnDomainHttpCodeDataRequest struct {
	*requests.RpcRequest
	DomainName     string `position:"Query" name:"DomainName"`
	EndTime        string `position:"Query" name:"EndTime"`
	Interval       string `position:"Query" name:"Interval"`
	LocationNameEn string `position:"Query" name:"LocationNameEn"`
	StartTime      string `position:"Query" name:"StartTime"`
	IspNameEn      string `position:"Query" name:"IspNameEn"`
}

// DescribeDcdnDomainHttpCodeDataResponse is the response struct for api DescribeDcdnDomainHttpCodeData
type DescribeDcdnDomainHttpCodeDataResponse struct {
	*responses.BaseResponse
	EndTime         string          `json:"EndTime" xml:"EndTime"`
	StartTime       string          `json:"StartTime" xml:"StartTime"`
	RequestId       string          `json:"RequestId" xml:"RequestId"`
	DomainName      string          `json:"DomainName" xml:"DomainName"`
	DataInterval    string          `json:"DataInterval" xml:"DataInterval"`
	DataPerInterval DataPerInterval `json:"DataPerInterval" xml:"DataPerInterval"`
}

// CreateDescribeDcdnDomainHttpCodeDataRequest creates a request to invoke DescribeDcdnDomainHttpCodeData API
func CreateDescribeDcdnDomainHttpCodeDataRequest() (request *DescribeDcdnDomainHttpCodeDataRequest) {
	request = &DescribeDcdnDomainHttpCodeDataRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dcdn", "2018-01-15", "DescribeDcdnDomainHttpCodeData", "", "")
	request.Method = requests.POST
	return
}

// CreateDescribeDcdnDomainHttpCodeDataResponse creates a response to parse from DescribeDcdnDomainHttpCodeData response
func CreateDescribeDcdnDomainHttpCodeDataResponse() (response *DescribeDcdnDomainHttpCodeDataResponse) {
	response = &DescribeDcdnDomainHttpCodeDataResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
