package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateQualityFollower invokes the dataworks_public.UpdateQualityFollower API synchronously
func (client *Client) UpdateQualityFollower(request *UpdateQualityFollowerRequest) (response *UpdateQualityFollowerResponse, err error) {
	response = CreateUpdateQualityFollowerResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateQualityFollowerWithChan invokes the dataworks_public.UpdateQualityFollower API asynchronously
func (client *Client) UpdateQualityFollowerWithChan(request *UpdateQualityFollowerRequest) (<-chan *UpdateQualityFollowerResponse, <-chan error) {
	responseChan := make(chan *UpdateQualityFollowerResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateQualityFollower(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateQualityFollowerWithCallback invokes the dataworks_public.UpdateQualityFollower API asynchronously
func (client *Client) UpdateQualityFollowerWithCallback(request *UpdateQualityFollowerRequest, callback func(response *UpdateQualityFollowerResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateQualityFollowerResponse
		var err error
		defer close(result)
		response, err = client.UpdateQualityFollower(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateQualityFollowerRequest is the request struct for api UpdateQualityFollower
type UpdateQualityFollowerRequest struct {
	*requests.RpcRequest
	ProjectName string           `position:"Body" name:"ProjectName"`
	Follower    string           `position:"Body" name:"Follower"`
	FollowerId  requests.Integer `position:"Body" name:"FollowerId"`
	AlarmMode   requests.Integer `position:"Body" name:"AlarmMode"`
	ProjectId   requests.Integer `position:"Body" name:"ProjectId"`
}

// UpdateQualityFollowerResponse is the response struct for api UpdateQualityFollower
type UpdateQualityFollowerResponse struct {
	*responses.BaseResponse
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Data           bool   `json:"Data" xml:"Data"`
	ErrorMessage   string `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	Success        bool   `json:"Success" xml:"Success"`
}

// CreateUpdateQualityFollowerRequest creates a request to invoke UpdateQualityFollower API
func CreateUpdateQualityFollowerRequest() (request *UpdateQualityFollowerRequest) {
	request = &UpdateQualityFollowerRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "UpdateQualityFollower", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateQualityFollowerResponse creates a response to parse from UpdateQualityFollower response
func CreateUpdateQualityFollowerResponse() (response *UpdateQualityFollowerResponse) {
	response = &UpdateQualityFollowerResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
