package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateDIJob invokes the dataworks_public.UpdateDIJob API synchronously
func (client *Client) UpdateDIJob(request *UpdateDIJobRequest) (response *UpdateDIJobResponse, err error) {
	response = CreateUpdateDIJobResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateDIJobWithChan invokes the dataworks_public.UpdateDIJob API asynchronously
func (client *Client) UpdateDIJobWithChan(request *UpdateDIJobRequest) (<-chan *UpdateDIJobResponse, <-chan error) {
	responseChan := make(chan *UpdateDIJobResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateDIJob(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateDIJobWithCallback invokes the dataworks_public.UpdateDIJob API asynchronously
func (client *Client) UpdateDIJobWithCallback(request *UpdateDIJobRequest, callback func(response *UpdateDIJobResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateDIJobResponse
		var err error
		defer close(result)
		response, err = client.UpdateDIJob(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateDIJobRequest is the request struct for api UpdateDIJob
type UpdateDIJobRequest struct {
	*requests.RpcRequest
	Description         string           `position:"Body" name:"Description"`
	TransformationRules string           `position:"Body" name:"TransformationRules"`
	DIJobId             requests.Integer `position:"Body" name:"DIJobId"`
	ResourceSettings    string           `position:"Body" name:"ResourceSettings"`
	TableMappings       string           `position:"Body" name:"TableMappings"`
	JobSettings         string           `position:"Body" name:"JobSettings"`
}

// UpdateDIJobResponse is the response struct for api UpdateDIJob
type UpdateDIJobResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateDIJobRequest creates a request to invoke UpdateDIJob API
func CreateUpdateDIJobRequest() (request *UpdateDIJobRequest) {
	request = &UpdateDIJobRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "UpdateDIJob", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateDIJobResponse creates a response to parse from UpdateDIJob response
func CreateUpdateDIJobResponse() (response *UpdateDIJobResponse) {
	response = &UpdateDIJobResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
