package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListMigrations invokes the dataworks_public.ListMigrations API synchronously
func (client *Client) ListMigrations(request *ListMigrationsRequest) (response *ListMigrationsResponse, err error) {
	response = CreateListMigrationsResponse()
	err = client.DoAction(request, response)
	return
}

// ListMigrationsWithChan invokes the dataworks_public.ListMigrations API asynchronously
func (client *Client) ListMigrationsWithChan(request *ListMigrationsRequest) (<-chan *ListMigrationsResponse, <-chan error) {
	responseChan := make(chan *ListMigrationsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListMigrations(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListMigrationsWithCallback invokes the dataworks_public.ListMigrations API asynchronously
func (client *Client) ListMigrationsWithCallback(request *ListMigrationsRequest, callback func(response *ListMigrationsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListMigrationsResponse
		var err error
		defer close(result)
		response, err = client.ListMigrations(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListMigrationsRequest is the request struct for api ListMigrations
type ListMigrationsRequest struct {
	*requests.RpcRequest
	Owner         string           `position:"Body" name:"Owner"`
	PageNumber    requests.Integer `position:"Body" name:"PageNumber"`
	PageSize      requests.Integer `position:"Body" name:"PageSize"`
	MigrationType string           `position:"Body" name:"MigrationType"`
	ProjectId     requests.Integer `position:"Body" name:"ProjectId"`
}

// ListMigrationsResponse is the response struct for api ListMigrations
type ListMigrationsResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Data      Data   `json:"Data" xml:"Data"`
}

// CreateListMigrationsRequest creates a request to invoke ListMigrations API
func CreateListMigrationsRequest() (request *ListMigrationsRequest) {
	request = &ListMigrationsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "ListMigrations", "", "")
	request.Method = requests.POST
	return
}

// CreateListMigrationsResponse creates a response to parse from ListMigrations response
func CreateListMigrationsResponse() (response *ListMigrationsResponse) {
	response = &ListMigrationsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
