package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetDIAlarmRule invokes the dataworks_public.GetDIAlarmRule API synchronously
func (client *Client) GetDIAlarmRule(request *GetDIAlarmRuleRequest) (response *GetDIAlarmRuleResponse, err error) {
	response = CreateGetDIAlarmRuleResponse()
	err = client.DoAction(request, response)
	return
}

// GetDIAlarmRuleWithChan invokes the dataworks_public.GetDIAlarmRule API asynchronously
func (client *Client) GetDIAlarmRuleWithChan(request *GetDIAlarmRuleRequest) (<-chan *GetDIAlarmRuleResponse, <-chan error) {
	responseChan := make(chan *GetDIAlarmRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetDIAlarmRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetDIAlarmRuleWithCallback invokes the dataworks_public.GetDIAlarmRule API asynchronously
func (client *Client) GetDIAlarmRuleWithCallback(request *GetDIAlarmRuleRequest, callback func(response *GetDIAlarmRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetDIAlarmRuleResponse
		var err error
		defer close(result)
		response, err = client.GetDIAlarmRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetDIAlarmRuleRequest is the request struct for api GetDIAlarmRule
type GetDIAlarmRuleRequest struct {
	*requests.RpcRequest
	DIAlarmRuleId requests.Integer `position:"Body" name:"DIAlarmRuleId"`
}

// GetDIAlarmRuleResponse is the response struct for api GetDIAlarmRule
type GetDIAlarmRuleResponse struct {
	*responses.BaseResponse
	RequestId   string      `json:"RequestId" xml:"RequestId"`
	DIAlarmRule DIAlarmRule `json:"DIAlarmRule" xml:"DIAlarmRule"`
}

// CreateGetDIAlarmRuleRequest creates a request to invoke GetDIAlarmRule API
func CreateGetDIAlarmRuleRequest() (request *GetDIAlarmRuleRequest) {
	request = &GetDIAlarmRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "GetDIAlarmRule", "", "")
	request.Method = requests.POST
	return
}

// CreateGetDIAlarmRuleResponse creates a response to parse from GetDIAlarmRule response
func CreateGetDIAlarmRuleResponse() (response *GetDIAlarmRuleResponse) {
	response = &GetDIAlarmRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
