package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DsgDesensPlanAddOrUpdate invokes the dataworks_public.DsgDesensPlanAddOrUpdate API synchronously
func (client *Client) DsgDesensPlanAddOrUpdate(request *DsgDesensPlanAddOrUpdateRequest) (response *DsgDesensPlanAddOrUpdateResponse, err error) {
	response = CreateDsgDesensPlanAddOrUpdateResponse()
	err = client.DoAction(request, response)
	return
}

// DsgDesensPlanAddOrUpdateWithChan invokes the dataworks_public.DsgDesensPlanAddOrUpdate API asynchronously
func (client *Client) DsgDesensPlanAddOrUpdateWithChan(request *DsgDesensPlanAddOrUpdateRequest) (<-chan *DsgDesensPlanAddOrUpdateResponse, <-chan error) {
	responseChan := make(chan *DsgDesensPlanAddOrUpdateResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DsgDesensPlanAddOrUpdate(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DsgDesensPlanAddOrUpdateWithCallback invokes the dataworks_public.DsgDesensPlanAddOrUpdate API asynchronously
func (client *Client) DsgDesensPlanAddOrUpdateWithCallback(request *DsgDesensPlanAddOrUpdateRequest, callback func(response *DsgDesensPlanAddOrUpdateResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DsgDesensPlanAddOrUpdateResponse
		var err error
		defer close(result)
		response, err = client.DsgDesensPlanAddOrUpdate(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DsgDesensPlanAddOrUpdateRequest is the request struct for api DsgDesensPlanAddOrUpdate
type DsgDesensPlanAddOrUpdateRequest struct {
	*requests.RpcRequest
	DesensRules *[]DsgDesensPlanAddOrUpdateDesensRules `position:"Query" name:"DesensRules"  type:"Json"`
}

// DsgDesensPlanAddOrUpdateDesensRules is a repeated param struct in DsgDesensPlanAddOrUpdateRequest
type DsgDesensPlanAddOrUpdateDesensRules struct {
	Owner          string                                        `name:"Owner"`
	DataType       string                                        `name:"DataType"`
	RuleName       string                                        `name:"RuleName"`
	Id             string                                        `name:"Id"`
	SceneIds       *[]string                                     `name:"SceneIds" type:"Repeated"`
	DesensPlan     DsgDesensPlanAddOrUpdateDesensRulesDesensPlan `name:"DesensPlan" type:"Struct"`
	CheckWatermark string                                        `name:"CheckWatermark"`
	Status         string                                        `name:"Status"`
}

// DsgDesensPlanAddOrUpdateDesensRulesDesensPlan is a repeated param struct in DsgDesensPlanAddOrUpdateRequest
type DsgDesensPlanAddOrUpdateDesensRulesDesensPlan struct {
	ExtParam       map[string]string `name:"ExtParam" type:"Map"`
	DesensPlanType string            `name:"DesensPlanType"`
}

// DsgDesensPlanAddOrUpdateResponse is the response struct for api DsgDesensPlanAddOrUpdate
type DsgDesensPlanAddOrUpdateResponse struct {
	*responses.BaseResponse
	Success        bool   `json:"Success" xml:"Success"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage   string `json:"ErrorMessage" xml:"ErrorMessage"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Data           bool   `json:"Data" xml:"Data"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
}

// CreateDsgDesensPlanAddOrUpdateRequest creates a request to invoke DsgDesensPlanAddOrUpdate API
func CreateDsgDesensPlanAddOrUpdateRequest() (request *DsgDesensPlanAddOrUpdateRequest) {
	request = &DsgDesensPlanAddOrUpdateRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "DsgDesensPlanAddOrUpdate", "", "")
	request.Method = requests.POST
	return
}

// CreateDsgDesensPlanAddOrUpdateResponse creates a response to parse from DsgDesensPlanAddOrUpdate response
func CreateDsgDesensPlanAddOrUpdateResponse() (response *DsgDesensPlanAddOrUpdateResponse) {
	response = &DsgDesensPlanAddOrUpdateResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
