package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteDIAlarmRule invokes the dataworks_public.DeleteDIAlarmRule API synchronously
func (client *Client) DeleteDIAlarmRule(request *DeleteDIAlarmRuleRequest) (response *DeleteDIAlarmRuleResponse, err error) {
	response = CreateDeleteDIAlarmRuleResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteDIAlarmRuleWithChan invokes the dataworks_public.DeleteDIAlarmRule API asynchronously
func (client *Client) DeleteDIAlarmRuleWithChan(request *DeleteDIAlarmRuleRequest) (<-chan *DeleteDIAlarmRuleResponse, <-chan error) {
	responseChan := make(chan *DeleteDIAlarmRuleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteDIAlarmRule(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteDIAlarmRuleWithCallback invokes the dataworks_public.DeleteDIAlarmRule API asynchronously
func (client *Client) DeleteDIAlarmRuleWithCallback(request *DeleteDIAlarmRuleRequest, callback func(response *DeleteDIAlarmRuleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteDIAlarmRuleResponse
		var err error
		defer close(result)
		response, err = client.DeleteDIAlarmRule(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteDIAlarmRuleRequest is the request struct for api DeleteDIAlarmRule
type DeleteDIAlarmRuleRequest struct {
	*requests.RpcRequest
	DIAlarmRuleId requests.Integer `position:"Body" name:"DIAlarmRuleId"`
}

// DeleteDIAlarmRuleResponse is the response struct for api DeleteDIAlarmRule
type DeleteDIAlarmRuleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteDIAlarmRuleRequest creates a request to invoke DeleteDIAlarmRule API
func CreateDeleteDIAlarmRuleRequest() (request *DeleteDIAlarmRuleRequest) {
	request = &DeleteDIAlarmRuleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "DeleteDIAlarmRule", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteDIAlarmRuleResponse creates a response to parse from DeleteDIAlarmRule response
func CreateDeleteDIAlarmRuleResponse() (response *DeleteDIAlarmRuleResponse) {
	response = &DeleteDIAlarmRuleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
