package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateConnection invokes the dataworks_public.CreateConnection API synchronously
func (client *Client) CreateConnection(request *CreateConnectionRequest) (response *CreateConnectionResponse, err error) {
	response = CreateCreateConnectionResponse()
	err = client.DoAction(request, response)
	return
}

// CreateConnectionWithChan invokes the dataworks_public.CreateConnection API asynchronously
func (client *Client) CreateConnectionWithChan(request *CreateConnectionRequest) (<-chan *CreateConnectionResponse, <-chan error) {
	responseChan := make(chan *CreateConnectionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateConnection(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateConnectionWithCallback invokes the dataworks_public.CreateConnection API asynchronously
func (client *Client) CreateConnectionWithCallback(request *CreateConnectionRequest, callback func(response *CreateConnectionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateConnectionResponse
		var err error
		defer close(result)
		response, err = client.CreateConnection(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateConnectionRequest is the request struct for api CreateConnection
type CreateConnectionRequest struct {
	*requests.RpcRequest
	Description    string           `position:"Query" name:"Description"`
	Content        string           `position:"Query" name:"Content"`
	SubType        string           `position:"Query" name:"SubType"`
	Name           string           `position:"Query" name:"Name"`
	EnvType        requests.Integer `position:"Query" name:"EnvType"`
	ConnectionType string           `position:"Query" name:"ConnectionType"`
	ProjectId      requests.Integer `position:"Query" name:"ProjectId"`
}

// CreateConnectionResponse is the response struct for api CreateConnection
type CreateConnectionResponse struct {
	*responses.BaseResponse
	HttpStatusCode string `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Data           int64  `json:"Data" xml:"Data"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
}

// CreateCreateConnectionRequest creates a request to invoke CreateConnection API
func CreateCreateConnectionRequest() (request *CreateConnectionRequest) {
	request = &CreateConnectionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "CreateConnection", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateConnectionResponse creates a response to parse from CreateConnection response
func CreateCreateConnectionResponse() (response *CreateConnectionResponse) {
	response = &CreateConnectionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
