package dataworks_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// AddProjectMemberToRole invokes the dataworks_public.AddProjectMemberToRole API synchronously
func (client *Client) AddProjectMemberToRole(request *AddProjectMemberToRoleRequest) (response *AddProjectMemberToRoleResponse, err error) {
	response = CreateAddProjectMemberToRoleResponse()
	err = client.DoAction(request, response)
	return
}

// AddProjectMemberToRoleWithChan invokes the dataworks_public.AddProjectMemberToRole API asynchronously
func (client *Client) AddProjectMemberToRoleWithChan(request *AddProjectMemberToRoleRequest) (<-chan *AddProjectMemberToRoleResponse, <-chan error) {
	responseChan := make(chan *AddProjectMemberToRoleResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.AddProjectMemberToRole(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// AddProjectMemberToRoleWithCallback invokes the dataworks_public.AddProjectMemberToRole API asynchronously
func (client *Client) AddProjectMemberToRoleWithCallback(request *AddProjectMemberToRoleRequest, callback func(response *AddProjectMemberToRoleResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *AddProjectMemberToRoleResponse
		var err error
		defer close(result)
		response, err = client.AddProjectMemberToRole(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// AddProjectMemberToRoleRequest is the request struct for api AddProjectMemberToRole
type AddProjectMemberToRoleRequest struct {
	*requests.RpcRequest
	RoleCode    string           `position:"Query" name:"RoleCode"`
	ClientToken string           `position:"Query" name:"ClientToken"`
	UserId      string           `position:"Query" name:"UserId"`
	ProjectId   requests.Integer `position:"Query" name:"ProjectId"`
}

// AddProjectMemberToRoleResponse is the response struct for api AddProjectMemberToRole
type AddProjectMemberToRoleResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateAddProjectMemberToRoleRequest creates a request to invoke AddProjectMemberToRole API
func CreateAddProjectMemberToRoleRequest() (request *AddProjectMemberToRoleRequest) {
	request = &AddProjectMemberToRoleRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("dataworks-public", "2020-05-18", "AddProjectMemberToRole", "", "")
	request.Method = requests.POST
	return
}

// CreateAddProjectMemberToRoleResponse creates a response to parse from AddProjectMemberToRole response
func CreateAddProjectMemberToRoleResponse() (response *AddProjectMemberToRoleResponse) {
	response = &AddProjectMemberToRoleResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
