package csb

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateServiceListStatus invokes the csb.UpdateServiceListStatus API synchronously
// api document: https://help.aliyun.com/api/csb/updateserviceliststatus.html
func (client *Client) UpdateServiceListStatus(request *UpdateServiceListStatusRequest) (response *UpdateServiceListStatusResponse, err error) {
	response = CreateUpdateServiceListStatusResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateServiceListStatusWithChan invokes the csb.UpdateServiceListStatus API asynchronously
// api document: https://help.aliyun.com/api/csb/updateserviceliststatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateServiceListStatusWithChan(request *UpdateServiceListStatusRequest) (<-chan *UpdateServiceListStatusResponse, <-chan error) {
	responseChan := make(chan *UpdateServiceListStatusResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateServiceListStatus(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateServiceListStatusWithCallback invokes the csb.UpdateServiceListStatus API asynchronously
// api document: https://help.aliyun.com/api/csb/updateserviceliststatus.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) UpdateServiceListStatusWithCallback(request *UpdateServiceListStatusRequest, callback func(response *UpdateServiceListStatusResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateServiceListStatusResponse
		var err error
		defer close(result)
		response, err = client.UpdateServiceListStatus(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateServiceListStatusRequest is the request struct for api UpdateServiceListStatus
type UpdateServiceListStatusRequest struct {
	*requests.RpcRequest
	Data  string           `position:"Body" name:"Data"`
	CsbId requests.Integer `position:"Query" name:"CsbId"`
}

// UpdateServiceListStatusResponse is the response struct for api UpdateServiceListStatus
type UpdateServiceListStatusResponse struct {
	*responses.BaseResponse
	Code      int    `json:"Code" xml:"Code"`
	Message   string `json:"Message" xml:"Message"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateServiceListStatusRequest creates a request to invoke UpdateServiceListStatus API
func CreateUpdateServiceListStatusRequest() (request *UpdateServiceListStatusRequest) {
	request = &UpdateServiceListStatusRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CSB", "2017-11-18", "UpdateServiceListStatus", "", "")
	request.Method = requests.POST
	return
}

// CreateUpdateServiceListStatusResponse creates a response to parse from UpdateServiceListStatus response
func CreateUpdateServiceListStatusResponse() (response *UpdateServiceListStatusResponse) {
	response = &UpdateServiceListStatusResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
