package csas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListApprovalProcesses invokes the csas.ListApprovalProcesses API synchronously
func (client *Client) ListApprovalProcesses(request *ListApprovalProcessesRequest) (response *ListApprovalProcessesResponse, err error) {
	response = CreateListApprovalProcessesResponse()
	err = client.DoAction(request, response)
	return
}

// ListApprovalProcessesWithChan invokes the csas.ListApprovalProcesses API asynchronously
func (client *Client) ListApprovalProcessesWithChan(request *ListApprovalProcessesRequest) (<-chan *ListApprovalProcessesResponse, <-chan error) {
	responseChan := make(chan *ListApprovalProcessesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListApprovalProcesses(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListApprovalProcessesWithCallback invokes the csas.ListApprovalProcesses API asynchronously
func (client *Client) ListApprovalProcessesWithCallback(request *ListApprovalProcessesRequest, callback func(response *ListApprovalProcessesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListApprovalProcessesResponse
		var err error
		defer close(result)
		response, err = client.ListApprovalProcesses(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListApprovalProcessesRequest is the request struct for api ListApprovalProcesses
type ListApprovalProcessesRequest struct {
	*requests.RpcRequest
	ProcessIds  *[]string        `position:"Query" name:"ProcessIds"  type:"Repeated"`
	SourceIp    string           `position:"Query" name:"SourceIp"`
	PolicyId    string           `position:"Query" name:"PolicyId"`
	SaseUserId  string           `position:"Query" name:"SaseUserId"`
	PageSize    requests.Integer `position:"Query" name:"PageSize"`
	PolicyType  string           `position:"Query" name:"PolicyType"`
	ProcessName string           `position:"Query" name:"ProcessName"`
	CurrentPage requests.Integer `position:"Query" name:"CurrentPage"`
	Username    string           `position:"Query" name:"Username"`
}

// ListApprovalProcessesResponse is the response struct for api ListApprovalProcesses
type ListApprovalProcessesResponse struct {
	*responses.BaseResponse
}

// CreateListApprovalProcessesRequest creates a request to invoke ListApprovalProcesses API
func CreateListApprovalProcessesRequest() (request *ListApprovalProcessesRequest) {
	request = &ListApprovalProcessesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("csas", "2023-01-20", "ListApprovalProcesses", "", "")
	request.Method = requests.GET
	return
}

// CreateListApprovalProcessesResponse creates a response to parse from ListApprovalProcesses response
func CreateListApprovalProcessesResponse() (response *ListApprovalProcessesResponse) {
	response = &ListApprovalProcessesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
