package csas

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DetachApplication2Connector invokes the csas.DetachApplication2Connector API synchronously
func (client *Client) DetachApplication2Connector(request *DetachApplication2ConnectorRequest) (response *DetachApplication2ConnectorResponse, err error) {
	response = CreateDetachApplication2ConnectorResponse()
	err = client.DoAction(request, response)
	return
}

// DetachApplication2ConnectorWithChan invokes the csas.DetachApplication2Connector API asynchronously
func (client *Client) DetachApplication2ConnectorWithChan(request *DetachApplication2ConnectorRequest) (<-chan *DetachApplication2ConnectorResponse, <-chan error) {
	responseChan := make(chan *DetachApplication2ConnectorResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DetachApplication2Connector(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DetachApplication2ConnectorWithCallback invokes the csas.DetachApplication2Connector API asynchronously
func (client *Client) DetachApplication2ConnectorWithCallback(request *DetachApplication2ConnectorRequest, callback func(response *DetachApplication2ConnectorResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DetachApplication2ConnectorResponse
		var err error
		defer close(result)
		response, err = client.DetachApplication2Connector(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DetachApplication2ConnectorRequest is the request struct for api DetachApplication2Connector
type DetachApplication2ConnectorRequest struct {
	*requests.RpcRequest
	ConnectorId    string    `position:"Body" name:"ConnectorId"`
	ApplicationIds *[]string `position:"Body" name:"ApplicationIds"  type:"Json"`
	SourceIp       string    `position:"Query" name:"SourceIp"`
}

// DetachApplication2ConnectorResponse is the response struct for api DetachApplication2Connector
type DetachApplication2ConnectorResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDetachApplication2ConnectorRequest creates a request to invoke DetachApplication2Connector API
func CreateDetachApplication2ConnectorRequest() (request *DetachApplication2ConnectorRequest) {
	request = &DetachApplication2ConnectorRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("csas", "2023-01-20", "DetachApplication2Connector", "", "")
	request.Method = requests.POST
	return
}

// CreateDetachApplication2ConnectorResponse creates a response to parse from DetachApplication2Connector response
func CreateDetachApplication2ConnectorResponse() (response *DetachApplication2ConnectorResponse) {
	response = &DetachApplication2ConnectorResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
