package config

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetAggregateAdvancedSearchFile invokes the config.GetAggregateAdvancedSearchFile API synchronously
func (client *Client) GetAggregateAdvancedSearchFile(request *GetAggregateAdvancedSearchFileRequest) (response *GetAggregateAdvancedSearchFileResponse, err error) {
	response = CreateGetAggregateAdvancedSearchFileResponse()
	err = client.DoAction(request, response)
	return
}

// GetAggregateAdvancedSearchFileWithChan invokes the config.GetAggregateAdvancedSearchFile API asynchronously
func (client *Client) GetAggregateAdvancedSearchFileWithChan(request *GetAggregateAdvancedSearchFileRequest) (<-chan *GetAggregateAdvancedSearchFileResponse, <-chan error) {
	responseChan := make(chan *GetAggregateAdvancedSearchFileResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetAggregateAdvancedSearchFile(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetAggregateAdvancedSearchFileWithCallback invokes the config.GetAggregateAdvancedSearchFile API asynchronously
func (client *Client) GetAggregateAdvancedSearchFileWithCallback(request *GetAggregateAdvancedSearchFileRequest, callback func(response *GetAggregateAdvancedSearchFileResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetAggregateAdvancedSearchFileResponse
		var err error
		defer close(result)
		response, err = client.GetAggregateAdvancedSearchFile(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetAggregateAdvancedSearchFileRequest is the request struct for api GetAggregateAdvancedSearchFile
type GetAggregateAdvancedSearchFileRequest struct {
	*requests.RpcRequest
	AggregatorId string `position:"Query" name:"AggregatorId"`
}

// GetAggregateAdvancedSearchFileResponse is the response struct for api GetAggregateAdvancedSearchFile
type GetAggregateAdvancedSearchFileResponse struct {
	*responses.BaseResponse
	RequestId      string         `json:"RequestId" xml:"RequestId"`
	ResourceSearch ResourceSearch `json:"ResourceSearch" xml:"ResourceSearch"`
}

// CreateGetAggregateAdvancedSearchFileRequest creates a request to invoke GetAggregateAdvancedSearchFile API
func CreateGetAggregateAdvancedSearchFileRequest() (request *GetAggregateAdvancedSearchFileRequest) {
	request = &GetAggregateAdvancedSearchFileRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Config", "2020-09-07", "GetAggregateAdvancedSearchFile", "", "")
	request.Method = requests.POST
	return
}

// CreateGetAggregateAdvancedSearchFileResponse creates a response to parse from GetAggregateAdvancedSearchFile response
func CreateGetAggregateAdvancedSearchFileResponse() (response *GetAggregateAdvancedSearchFileResponse) {
	response = &GetAggregateAdvancedSearchFileResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
