package codeup

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListRepositories invokes the codeup.ListRepositories API synchronously
func (client *Client) ListRepositories(request *ListRepositoriesRequest) (response *ListRepositoriesResponse, err error) {
	response = CreateListRepositoriesResponse()
	err = client.DoAction(request, response)
	return
}

// ListRepositoriesWithChan invokes the codeup.ListRepositories API asynchronously
func (client *Client) ListRepositoriesWithChan(request *ListRepositoriesRequest) (<-chan *ListRepositoriesResponse, <-chan error) {
	responseChan := make(chan *ListRepositoriesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListRepositories(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListRepositoriesWithCallback invokes the codeup.ListRepositories API asynchronously
func (client *Client) ListRepositoriesWithCallback(request *ListRepositoriesRequest, callback func(response *ListRepositoriesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListRepositoriesResponse
		var err error
		defer close(result)
		response, err = client.ListRepositories(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListRepositoriesRequest is the request struct for api ListRepositories
type ListRepositoriesRequest struct {
	*requests.RoaRequest
	AccessToken    string           `position:"Query" name:"AccessToken"`
	Archive        requests.Boolean `position:"Query" name:"Archive"`
	Sort           string           `position:"Query" name:"Sort"`
	OrganizationId string           `position:"Query" name:"OrganizationId"`
	Search         string           `position:"Query" name:"Search"`
	PageSize       requests.Integer `position:"Query" name:"PageSize"`
	Page           requests.Integer `position:"Query" name:"Page"`
	Order          string           `position:"Query" name:"Order"`
}

// ListRepositoriesResponse is the response struct for api ListRepositories
type ListRepositoriesResponse struct {
	*responses.BaseResponse
	ErrorCode    int                            `json:"ErrorCode" xml:"ErrorCode"`
	ErrorMessage string                         `json:"ErrorMessage" xml:"ErrorMessage"`
	RequestId    string                         `json:"RequestId" xml:"RequestId"`
	Success      bool                           `json:"Success" xml:"Success"`
	Total        int64                          `json:"Total" xml:"Total"`
	Result       []ResultItemInListRepositories `json:"Result" xml:"Result"`
}

// CreateListRepositoriesRequest creates a request to invoke ListRepositories API
func CreateListRepositoriesRequest() (request *ListRepositoriesRequest) {
	request = &ListRepositoriesRequest{
		RoaRequest: &requests.RoaRequest{},
	}
	request.InitWithApiInfo("codeup", "2020-04-14", "ListRepositories", "/api/v3/projects/all", "", "")
	request.Method = requests.GET
	return
}

// CreateListRepositoriesResponse creates a response to parse from ListRepositories response
func CreateListRepositoriesResponse() (response *ListRepositoriesResponse) {
	response = &ListRepositoriesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
