package cloudgameapi

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryOrder invokes the cloudgameapi.QueryOrder API synchronously
func (client *Client) QueryOrder(request *QueryOrderRequest) (response *QueryOrderResponse, err error) {
	response = CreateQueryOrderResponse()
	err = client.DoAction(request, response)
	return
}

// QueryOrderWithChan invokes the cloudgameapi.QueryOrder API asynchronously
func (client *Client) QueryOrderWithChan(request *QueryOrderRequest) (<-chan *QueryOrderResponse, <-chan error) {
	responseChan := make(chan *QueryOrderResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryOrder(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryOrderWithCallback invokes the cloudgameapi.QueryOrder API asynchronously
func (client *Client) QueryOrderWithCallback(request *QueryOrderRequest, callback func(response *QueryOrderResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryOrderResponse
		var err error
		defer close(result)
		response, err = client.QueryOrder(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryOrderRequest is the request struct for api QueryOrder
type QueryOrderRequest struct {
	*requests.RpcRequest
	AccountDomain  string `position:"Query" name:"AccountDomain"`
	OrderId        string `position:"Query" name:"OrderId"`
	BuyerAccountId string `position:"Query" name:"BuyerAccountId"`
}

// QueryOrderResponse is the response struct for api QueryOrder
type QueryOrderResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	DeliveryStatus string `json:"DeliveryStatus" xml:"DeliveryStatus"`
	RefundStatus   string `json:"RefundStatus" xml:"RefundStatus"`
	Data           Data   `json:"Data" xml:"Data"`
}

// CreateQueryOrderRequest creates a request to invoke QueryOrder API
func CreateQueryOrderRequest() (request *QueryOrderRequest) {
	request = &QueryOrderRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudGameAPI", "2020-07-28", "QueryOrder", "", "")
	request.Method = requests.POST
	return
}

// CreateQueryOrderResponse creates a response to parse from QueryOrder response
func CreateQueryOrderResponse() (response *QueryOrderResponse) {
	response = &QueryOrderResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
