package cloudfw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyControlPolicy invokes the cloudfw.ModifyControlPolicy API synchronously
func (client *Client) ModifyControlPolicy(request *ModifyControlPolicyRequest) (response *ModifyControlPolicyResponse, err error) {
	response = CreateModifyControlPolicyResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyControlPolicyWithChan invokes the cloudfw.ModifyControlPolicy API asynchronously
func (client *Client) ModifyControlPolicyWithChan(request *ModifyControlPolicyRequest) (<-chan *ModifyControlPolicyResponse, <-chan error) {
	responseChan := make(chan *ModifyControlPolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyControlPolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyControlPolicyWithCallback invokes the cloudfw.ModifyControlPolicy API asynchronously
func (client *Client) ModifyControlPolicyWithCallback(request *ModifyControlPolicyRequest, callback func(response *ModifyControlPolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyControlPolicyResponse
		var err error
		defer close(result)
		response, err = client.ModifyControlPolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyControlPolicyRequest is the request struct for api ModifyControlPolicy
type ModifyControlPolicyRequest struct {
	*requests.RpcRequest
	DestPortType        string    `position:"Query" name:"DestPortType"`
	MessageType         string    `position:"Query" name:"MessageType"`
	Release             string    `position:"Query" name:"Release"`
	Destination         string    `position:"Query" name:"Destination"`
	DestinationType     string    `position:"Query" name:"DestinationType"`
	DestPortGroup       string    `position:"Query" name:"DestPortGroup"`
	ApplicationNameList *[]string `position:"Query" name:"ApplicationNameList"  type:"Repeated"`
	Description         string    `position:"Query" name:"Description"`
	Source              string    `position:"Query" name:"Source"`
	AclUuid             string    `position:"Query" name:"AclUuid"`
	AclAction           string    `position:"Query" name:"AclAction"`
	SourceIp            string    `position:"Query" name:"SourceIp"`
	SourceType          string    `position:"Query" name:"SourceType"`
	Lang                string    `position:"Query" name:"Lang"`
	Direction           string    `position:"Query" name:"Direction"`
	ApplicationName     string    `position:"Query" name:"ApplicationName"`
	Proto               string    `position:"Query" name:"Proto"`
	DestPort            string    `position:"Query" name:"DestPort"`
}

// ModifyControlPolicyResponse is the response struct for api ModifyControlPolicy
type ModifyControlPolicyResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyControlPolicyRequest creates a request to invoke ModifyControlPolicy API
func CreateModifyControlPolicyRequest() (request *ModifyControlPolicyRequest) {
	request = &ModifyControlPolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudfw", "2017-12-07", "ModifyControlPolicy", "cloudfirewall", "openAPI")
	request.Method = requests.POST
	return
}

// CreateModifyControlPolicyResponse creates a response to parse from ModifyControlPolicy response
func CreateModifyControlPolicyResponse() (response *ModifyControlPolicyResponse) {
	response = &ModifyControlPolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
