package cloudfw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeUserIPSWhitelist invokes the cloudfw.DescribeUserIPSWhitelist API synchronously
func (client *Client) DescribeUserIPSWhitelist(request *DescribeUserIPSWhitelistRequest) (response *DescribeUserIPSWhitelistResponse, err error) {
	response = CreateDescribeUserIPSWhitelistResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeUserIPSWhitelistWithChan invokes the cloudfw.DescribeUserIPSWhitelist API asynchronously
func (client *Client) DescribeUserIPSWhitelistWithChan(request *DescribeUserIPSWhitelistRequest) (<-chan *DescribeUserIPSWhitelistResponse, <-chan error) {
	responseChan := make(chan *DescribeUserIPSWhitelistResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeUserIPSWhitelist(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeUserIPSWhitelistWithCallback invokes the cloudfw.DescribeUserIPSWhitelist API asynchronously
func (client *Client) DescribeUserIPSWhitelistWithCallback(request *DescribeUserIPSWhitelistRequest, callback func(response *DescribeUserIPSWhitelistResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeUserIPSWhitelistResponse
		var err error
		defer close(result)
		response, err = client.DescribeUserIPSWhitelist(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeUserIPSWhitelistRequest is the request struct for api DescribeUserIPSWhitelist
type DescribeUserIPSWhitelistRequest struct {
	*requests.RpcRequest
	SourceIp string `position:"Query" name:"SourceIp"`
	Lang     string `position:"Query" name:"Lang"`
}

// DescribeUserIPSWhitelistResponse is the response struct for api DescribeUserIPSWhitelist
type DescribeUserIPSWhitelistResponse struct {
	*responses.BaseResponse
	RequestId      string      `json:"RequestId" xml:"RequestId"`
	Whitelists     []RulesItem `json:"Whitelists" xml:"Whitelists"`
	Ipv6Whitelists []RulesItem `json:"Ipv6Whitelists" xml:"Ipv6Whitelists"`
}

// CreateDescribeUserIPSWhitelistRequest creates a request to invoke DescribeUserIPSWhitelist API
func CreateDescribeUserIPSWhitelistRequest() (request *DescribeUserIPSWhitelistRequest) {
	request = &DescribeUserIPSWhitelistRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudfw", "2017-12-07", "DescribeUserIPSWhitelist", "cloudfirewall", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeUserIPSWhitelistResponse creates a response to parse from DescribeUserIPSWhitelist response
func CreateDescribeUserIPSWhitelistResponse() (response *DescribeUserIPSWhitelistResponse) {
	response = &DescribeUserIPSWhitelistResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
