package cloudfw

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateVpcFirewallControlPolicy invokes the cloudfw.CreateVpcFirewallControlPolicy API synchronously
func (client *Client) CreateVpcFirewallControlPolicy(request *CreateVpcFirewallControlPolicyRequest) (response *CreateVpcFirewallControlPolicyResponse, err error) {
	response = CreateCreateVpcFirewallControlPolicyResponse()
	err = client.DoAction(request, response)
	return
}

// CreateVpcFirewallControlPolicyWithChan invokes the cloudfw.CreateVpcFirewallControlPolicy API asynchronously
func (client *Client) CreateVpcFirewallControlPolicyWithChan(request *CreateVpcFirewallControlPolicyRequest) (<-chan *CreateVpcFirewallControlPolicyResponse, <-chan error) {
	responseChan := make(chan *CreateVpcFirewallControlPolicyResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateVpcFirewallControlPolicy(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateVpcFirewallControlPolicyWithCallback invokes the cloudfw.CreateVpcFirewallControlPolicy API asynchronously
func (client *Client) CreateVpcFirewallControlPolicyWithCallback(request *CreateVpcFirewallControlPolicyRequest, callback func(response *CreateVpcFirewallControlPolicyResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateVpcFirewallControlPolicyResponse
		var err error
		defer close(result)
		response, err = client.CreateVpcFirewallControlPolicy(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateVpcFirewallControlPolicyRequest is the request struct for api CreateVpcFirewallControlPolicy
type CreateVpcFirewallControlPolicyRequest struct {
	*requests.RpcRequest
	DestPortType        string    `position:"Query" name:"DestPortType"`
	Release             string    `position:"Query" name:"Release"`
	Destination         string    `position:"Query" name:"Destination"`
	DestinationType     string    `position:"Query" name:"DestinationType"`
	DestPortGroup       string    `position:"Query" name:"DestPortGroup"`
	ApplicationNameList *[]string `position:"Query" name:"ApplicationNameList"  type:"Repeated"`
	Description         string    `position:"Query" name:"Description"`
	Source              string    `position:"Query" name:"Source"`
	AclAction           string    `position:"Query" name:"AclAction"`
	SourceIp            string    `position:"Query" name:"SourceIp"`
	NewOrder            string    `position:"Query" name:"NewOrder"`
	SourceType          string    `position:"Query" name:"SourceType"`
	Lang                string    `position:"Query" name:"Lang"`
	VpcFirewallId       string    `position:"Query" name:"VpcFirewallId"`
	ApplicationName     string    `position:"Query" name:"ApplicationName"`
	MemberUid           string    `position:"Query" name:"MemberUid"`
	Proto               string    `position:"Query" name:"Proto"`
	DestPort            string    `position:"Query" name:"DestPort"`
}

// CreateVpcFirewallControlPolicyResponse is the response struct for api CreateVpcFirewallControlPolicy
type CreateVpcFirewallControlPolicyResponse struct {
	*responses.BaseResponse
	AclUuid   string `json:"AclUuid" xml:"AclUuid"`
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateCreateVpcFirewallControlPolicyRequest creates a request to invoke CreateVpcFirewallControlPolicy API
func CreateCreateVpcFirewallControlPolicyRequest() (request *CreateVpcFirewallControlPolicyRequest) {
	request = &CreateVpcFirewallControlPolicyRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cloudfw", "2017-12-07", "CreateVpcFirewallControlPolicy", "cloudfirewall", "openAPI")
	request.Method = requests.POST
	return
}

// CreateCreateVpcFirewallControlPolicyResponse creates a response to parse from CreateVpcFirewallControlPolicy response
func CreateCreateVpcFirewallControlPolicyResponse() (response *CreateVpcFirewallControlPolicyResponse) {
	response = &CreateVpcFirewallControlPolicyResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
