package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ModifyVnNluProfile invokes the cloudcallcenter.ModifyVnNluProfile API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/modifyvnnluprofile.html
func (client *Client) ModifyVnNluProfile(request *ModifyVnNluProfileRequest) (response *ModifyVnNluProfileResponse, err error) {
	response = CreateModifyVnNluProfileResponse()
	err = client.DoAction(request, response)
	return
}

// ModifyVnNluProfileWithChan invokes the cloudcallcenter.ModifyVnNluProfile API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/modifyvnnluprofile.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyVnNluProfileWithChan(request *ModifyVnNluProfileRequest) (<-chan *ModifyVnNluProfileResponse, <-chan error) {
	responseChan := make(chan *ModifyVnNluProfileResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ModifyVnNluProfile(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ModifyVnNluProfileWithCallback invokes the cloudcallcenter.ModifyVnNluProfile API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/modifyvnnluprofile.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ModifyVnNluProfileWithCallback(request *ModifyVnNluProfileRequest, callback func(response *ModifyVnNluProfileResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ModifyVnNluProfileResponse
		var err error
		defer close(result)
		response, err = client.ModifyVnNluProfile(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ModifyVnNluProfileRequest is the request struct for api ModifyVnNluProfile
type ModifyVnNluProfileRequest struct {
	*requests.RpcRequest
	SecretKey    string `position:"Query" name:"SecretKey"`
	InstanceId   string `position:"Query" name:"InstanceId"`
	AccessKey    string `position:"Query" name:"AccessKey"`
	ChatEndpoint string `position:"Query" name:"ChatEndpoint"`
	Deployment   string `position:"Query" name:"Deployment"`
}

// ModifyVnNluProfileResponse is the response struct for api ModifyVnNluProfile
type ModifyVnNluProfileResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateModifyVnNluProfileRequest creates a request to invoke ModifyVnNluProfile API
func CreateModifyVnNluProfileRequest() (request *ModifyVnNluProfileRequest) {
	request = &ModifyVnNluProfileRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "ModifyVnNluProfile", "", "")
	request.Method = requests.GET
	return
}

// CreateModifyVnNluProfileResponse creates a response to parse from ModifyVnNluProfile response
func CreateModifyVnNluProfileResponse() (response *ModifyVnNluProfileResponse) {
	response = &ModifyVnNluProfileResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
